% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ft.R
\name{NumericOutcomeTreatment}
\alias{NumericOutcomeTreatment}
\title{Stateful object for designing and applying numeric outcome treatments.}
\usage{
NumericOutcomeTreatment(
  ...,
  var_list,
  outcome_name,
  cols_to_copy = NULL,
  params = NULL,
  imputation_map = NULL
)
}
\arguments{
\item{...}{not used, force arguments to be specified by name.}

\item{var_list}{Names of columns to treat (effective variables).}

\item{outcome_name}{Name of column holding outcome variable. \code{dframe[[outcomename]]} must be only finite non-missing values.}

\item{cols_to_copy}{list of extra columns to copy.}

\item{params}{parameters list from \code{regression_parameters}}

\item{imputation_map}{map from column names to functions of signature f(values: numeric, weights: numeric), simple missing value imputers.}
}
\description{
Hold settings and results for regression data preparation.
}
\details{
Please see
\url{https://github.com/WinVector/vtreat/blob/master/Examples/fit_transform/fit_transform_api.md},
\code{\link{mkCrossFrameNExperiment}}, 
\code{\link{designTreatmentsN}}, and
\code{\link{prepare.treatmentplan}} for details.
}
