% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isotone.R
\name{solveNonIncreasing}
\alias{solveNonIncreasing}
\title{Solve for best non-increasing fit.}
\usage{
solveNonIncreasing(varName, x, y, w = NULL)
}
\arguments{
\item{varName}{character, name of variable}

\item{x}{numeric, factor, or character input (not empty, no NAs).}

\item{y}{numeric (same length as x no NAs), output to match}

\item{w}{numeric positive, same length as x (weights, can be NULL)}
}
\value{
isotonicly adjusted y (non-decreasing)
}
\description{
Return a vector of length y that is a function of x
(differs at must where x differs) obeying the opposite order
constraints as x.  This vector is picked as close to
y (by square-distance) as possible.
}
\details{
Please see \url{https://github.com/WinVector/vtreat/blob/master/extras/MonotoneCoder.md}.
}
\examples{


if(requireNamespace("isotone", quietly = TRUE)) {
   solveNonIncreasing('v', 1:3, c(1,2,1))
}

}
