% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGAMM.R
\name{plotGAMM}
\alias{plotGAMM}
\title{GAMM plotting using ggplot2}
\usage{
plotGAMM(gammFit, smooth.cov, groupCovs = NULL, orderedAsFactor = T,
  rawOrFitted = F, plotCI = T, grouping = NULL)
}
\arguments{
\item{gammFit}{fitted gam model as produced by gamm4::gamm()}

\item{smooth.cov}{(character) name of smooth term to be plotted}

\item{groupCovs}{(character)  name of group variable to plot by, if NULL (default) then there are no groups in plot}

\item{orderedAsFactor}{if TRUE (default) then the model is refitted with ordered variables as factors.}

\item{rawOrFitted}{If FALSE (default) then only smooth terms are plotted; if rawOrFitted = "raw" then raw values are plotted against smooth; if rawOrFitted = "fitted" then fitted values are plotted against smooth}

\item{plotCI}{if TRUE (default) upper and lower confidence intervals are added at 2 standard errors above and below the mean}

\item{grouping}{(character) Name of variable that you want to use as the group argument in ggplot2::aes(), useful for better visualization of longitudinal data, (default is NULL)}
}
\value{
Returns a ggplot object that can be visualized using the print() function
}
\description{
GAMM plotting using ggplot2
}
\examples{

set.seed(1)
data <- data.frame(x = (seq(.25,25, .25) +rnorm(100)), group = rep(1:2, 5), z=rnorm(100),
              index.rnorm = rep(rnorm(50, sd = 50), 2), index.var = rep(1:50, 2))
data$y <- (data$x)*data$group*10 + rnorm(100, sd = 700) + data$index.rnorm + data$z
data$group <- ordered(data$group)
gamm <- gamm4::gamm4(y ~ + s(x) + s(x, by=group) + z + group, data=data, random = ~ (1|index.var))
plot <- plotGAMM(gammFit <- gamm, smooth.cov <- "x", groupCovs = "group", 
                    plotCI <- T, rawOrFitted = "raw", grouping = "index.var")
plot

plot2 <- plotGAMM(gammFit <- gamm, smooth.cov <- "x", groupCovs = "group", 
                  plotCI <- T, rawOrFitted = "fitted", grouping = "index.var")
plot2
}
\seealso{
Other Plotting: \code{\link{plotGAM}}
}
