% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anovagammVoxel.R
\name{anovagammVoxel}
\alias{anovagammVoxel}
\title{Computes analysis of variance tables for a Generalized Additive Mixed Effects Model on all voxels of a NIfTI image within a mask.}
\usage{
anovagammVoxel(image, mask, fourdOut = NULL, formula, randomFormula, subjData,
  dispersion = NULL, freq = FALSE, p.type = 0, mc.preschedule = TRUE,
  ncores = 1, ...)
}
\arguments{
\item{image}{Input image of type 'nifti' or vector of path(s) to images. If multiple paths, the script will call mergeNifti() and merge across time.}

\item{mask}{Input mask of type 'nifti' or path to mask. Must be a binary mask}

\item{fourdOut}{To be passed to mergeNifti, This is the path and file name without the suffix to save the fourd file. Default (NULL) means script won't write out 4D image.}

\item{formula}{Must be a formula passed to gamm4()}

\item{randomFormula}{Random effects formual passed to gamm4()}

\item{subjData}{Dataframe containing all the covariates used for the analysis}

\item{dispersion}{To be passed to mgcv::anova.gam, Defaults to NULL. Dispersion Parameter, not normally used.}

\item{freq}{To be passed to mgcv::anova.gam, Defaults to FALSE. Frequentist or Bayesian approximations for p-values}

\item{p.type}{To be passed to mgcv::anova.gam, Defaults to 0. Exact test statistics o use for smooth terms.}

\item{mc.preschedule}{Argument to be passed to mclapply, whether or not to preschedule the jobs. More info in parallel::mclapply}

\item{ncores}{Number of cores to use}

\item{...}{Additional arguments passed to gamm4()}
}
\value{
Returns list of models fitted to each voxel over the masked images passed to function.
}
\description{
This function computes analysis of variance tables for the fitted models after running a Generalized Additive Mixed Effects Model (from gamm4::gamm4). 
The analysis will run in all voxels in the mask and will return the analysis of variance table for each voxel.
Please check anova::gam to learn more about the function of the arguments that are passed to anova.gam. Multi-model calls are disabled.
}
\examples{


image <- oro.nifti::nifti(img = array(1:1600, dim =c(4,4,4,25)))
mask <- oro.nifti::nifti(img = array(c(rep(0,15), rep(1,1)), dim = c(4,4,4,1)))
set.seed(1)
covs <- data.frame(x = runif(25), y=runif(25), id = rep(1:5,5))
f1 <- "~ s(x) + y"
randomFormula <- "~(1|id)"
models <- anovagammVoxel(image, mask, formula = f1, randomFormula = randomFormula, 
                                                             subjData = covs, ncores = 1, REML=TRUE)
}

