% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/semipar.mp.R
\name{semipar.mp}
\alias{semipar.mp}
\title{Massively parallel semiparametric regression}
\usage{
semipar.mp(formula, Y, lsp, data = NULL, range.basis = NULL,
  knots = "quantile", rm.constr = FALSE, random = NULL,
  store.reml = FALSE, store.fitted = FALSE)
}
\arguments{
\item{formula}{a formula object such as "\code{~ x1 + sf(x2) +sf(x2, effect
= x3)}" where \code{x1} is a linear (parametric) predictor, \code{x2} is a
predictor on which the responses depend smoothly, and \code{x3} is a
predictor whose effect is linear but varies smoothly with \code{x2} (i.e., a
varying-coefficient predictor).}

\item{Y}{an \eqn{n \times V} response matrix, where \eqn{V} is the number of
models fitted in parallel, e.g., voxels in neuroimaging applications.}

\item{lsp}{vector of candidate log tuning parameters (\eqn{log(\lambda)}).}

\item{data}{an optional data frame containing the variables in the model.}

\item{range.basis}{a numeric vector of length 2 defining the interval over
which the B-spline basis is created. If \code{NULL}, it will be set as the
range of the variable to be evaluated by the basis.}

\item{knots}{knot placement for the B-spline bases. The default,
\code{"quantile"}, gives knots at equally spaced quantiles of the data. The
alternative, \code{"equispaced"}, gives equally spaced knots.}

\item{rm.constr}{logical: should the constraints be removed for
varying-coefficient models?}

\item{random}{a formula or a matrix for random effects.}

\item{store.reml}{logical: should the pointwise REML criterion at each grid
point be included in the output?  \code{FALSE} by default, as this output
can be very large.}

\item{store.fitted}{logical: should the fitted values be included in the
output? \code{FALSE} by default.}
}
\value{
An object of class \code{"semipar.mp"}, which is also of class
\code{"\link{qplsc.mp}"} but includes the following additional elements:
\item{where.sf, where.nsf}{vectors or scalars identifying where the smooth
and non-smooth terms, respectively, appear in the model formula.}
\item{list.all}{a list of lists, one for each term of the model; see
Details.} \item{formula}{model formula.} \item{Y}{response matrix.}
\item{lsp}{candidate values for the log smoothing parameter.}
\item{data}{the supplied data frame, if any.}
}
\description{
Fits a possibly very large number of semiparametric models by quadratically
penalized least squares.  The model may include a combination of parametric
terms, smooth terms, varying-coefficient terms, and simple random effect
structures.
}
\details{
The basic approach to massively parallel smoothing is described in Reiss et
al. (2014). Although simple mixed-effect models are available,
\code{\link{semipar.mix.mp}} is generally preferable for mixed models with a
single smooth term.

Each element of \code{list.all} corresponding to a \emph{nonparametric} term
of the model is a list with components \code{modmat}, \code{penmat},
\code{pen.order}, \code{start}, and \code{end}. For each \emph{parametric}
term, the same five components are included, plus \code{basis},
\code{argvals}, \code{effect}, \code{k}, and \code{norder}.
}
\examples{
n<-32
Ys <- matrix(0, n, 5)
for(i in 1:n) Ys[i,]<--2:2+rnorm(5, i^2, i^0.5)+sin(i)
x1 <- rnorm(n,0,5)
x2 <- 1:n+runif(n, 1, 20)
semipar.obj <- semipar.mp(~x1+sf(x2,k=10),Y=Ys,lsp=seq(5,50,,30))
}
\author{
Yin-Hsiu Chen \email{enjoychen0701@gmail.com} and Philip Reiss
\email{phil.reiss@nyumc.org}
}
\references{
Reiss, P. T., Huang, L., Chen, Y.-H., Huo, L., Tarpey, T., and
Mennes, M. (2014). Massively parallel nonparametric regression, with an
application to developmental brain mapping. \emph{Journal of Computational
and Graphical Statistics}, \emph{Journal of Computational and Graphical
Statistics}, 23(1), 232--248.
}

