% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/rlrtpanel.R
\name{rlrtpanel}
\alias{rlrtpanel}
\title{Interactive visualization of voxelwise RLRT results}
\usage{
rlrtpanel(rlrtobj, array4d, predictor, disp = c("stat", "p", "fdr"),
  titl = "", xlab = "Age", ylab = "", slice = (dim(array4d)[3]\%/\%2),
  ylim.scatter = NULL, col.image = shape::femmecol(100), neglog10 = FALSE,
  threshold = NULL)
}
\arguments{
\item{rlrtobj}{an RLRT object as produced by \code{\link{rlrt4d}}.}

\item{array4d}{a 4-dimensional array containing the raw data that were
smoothed at each point.  The first 3 dimensions refer to x, y, and z
coordinates and the last dimension corresponds to different images.}

\item{predictor}{a vector or matrix of covariates.}

\item{disp}{values from the RLRT object to be displayed: either RLRT
statistics, p-values, or FDR values.}

\item{titl}{title of the panel.}

\item{xlab,ylab}{x- and y-axis labels.}

\item{slice}{index of the default slice to be shown in the panel.}

\item{ylim.scatter}{the y limits of the scatterplots.}

\item{col.image}{a list of colors such as that generated by rainbow,
heat.colors, topo.colors, terrain.colors or similar functions.}

\item{neglog10}{logical; if \code{TRUE}, negative base \code{10} logarithm
(of the quantity specified by \code{disp}) is displayed.}

\item{threshold}{the upper limit of the values to be plotted. All larger
values will be replaced by the threshold value.}
}
\description{
This function uses interactive graphics tools, provided by the \pkg{rpanel}
package, to visualize the results of massively parallel RLRT results as
produced by \code{\link{rlrt4d}}.
}
\details{
RLRT results are shown for a cross-section (slice), and a slider allows
viewing of different slices.  Clicking on a voxel produces a scatterplot of
the data at that voxel.
}
\examples{
# Please see example for rlrt4d
}
\author{
Lei Huang \email{huangracer@gmail.com}
}
\references{
Bowman, A., Crawford, E., Alexander, G., and Bowman, R. (2007).
rpanel: Simple interactive controls for R functions using the tcltk package.
\emph{Journal of Statistical Software}, 17(9).
}
\seealso{
\code{\link{rlrt4d}}
}

