% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rating_get_candidate_ratings.R
\name{rating_get_candidate_ratings}
\alias{rating_get_candidate_ratings}
\title{Get SIG (Special Interest Group) ratings for candidates}
\usage{
rating_get_candidate_ratings(
  candidate_ids,
  sig_ids = "",
  all = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{candidate_ids}{A vector of candidate ids.}

\item{sig_ids}{A vector of SIG ids. Default is \code{""} for all SIGs.}

\item{all}{Boolean: should all possible combinations of the variables be searched for, or just the exact combination of them in the order they are supplied?}

\item{verbose}{Should cases when no data is available be messaged?}
}
\value{
A dataframe with the columns \code{rating_id, candidate_id, sig_id, rating, rating_name, timespan, categories, rating_text}.
}
\description{
Get SIG (Special Interest Group) ratings for candidates
}
\examples{
\dontrun{
pelosi_id <- "26732"
rating_get_candidate_ratings(pelosi_id)
}
}
