% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inputProcessingUtilties.R
\name{bottomRaster}
\alias{bottomRaster}
\title{Bottom raster generation}
\usage{
bottomRaster(rawPointData)
}
\arguments{
\item{rawPointData}{A \code{SpatialPointsDataFrame} object from which
bottom variables will be sampled. See Details for more about format.}
}
\value{
A \code{RasterLayer} designed to approximate sea bottom
measurements for modeling species' distributions and/or niches.
}
\description{
Samples deepest depth values from a
\code{SpatialPointsDataFrame} and generates a \code{RasterLayer}.
}
\details{
\code{rawPointData} is a \code{SpatialPointsDataFrame} object that
contains measurements of a single environmental variable (e.g.
salinity, temperature, etc.) with x, y, and z coordinates. The
measurements in the \code{data.frame} should be organized so that each
column is a depth slice, increasing in depth from left to right. The
function was designed around the oceanographic data shapefiles supplied
by the World Ocean Atlas
(\url{https://www.ncei.noaa.gov/access/world-ocean-atlas-2018/}).
The function selects the "deepest" (rightmost) measurement at each
x, y coordinate pair that contains data. These measurements are then
rasterized at the resolution and extent of the x,y coordinates.
}
\examples{

library(sp)

# Create point grid
coords <- data.frame(x = rep(seq(1:5), times = 5),
                    y = unlist(lapply(1:5, FUN = function(x) {
                      rep(x, times = 5)})))

# Create data and add NAs to simulate uneven bottom depths
dd <- data.frame(SURFACE = 1:25,
                d5M = 6:30,
                d10M = 11:35,
                d25M = 16:40)
dd$d25M[c(1:5, 18:25)] <- NA
dd$d10M[c(3:5, 21:23)] <- NA
dd$d5M[c(4, 22)] <- NA

# Create SpatialPointsDataFrame
sp <- sp::SpatialPointsDataFrame(coords = coords,
                            data = dd)

# Here's the function
result <- bottomRaster(rawPointData = sp)
plot(result)

}
\keyword{inputProcessing}
