% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{direct_sampling}
\alias{direct_sampling}
\title{Sample perfect uniformly distributed points from well known convex bodies: (a) the unit simplex, (b) the canonical simplex, (c) the boundary of a hypersphere or (d) the interior of a hypersphere.}
\usage{
direct_sampling(body, n, seed = NULL)
}
\arguments{
\item{body}{A list to request exact uniform sampling from special well known convex bodies through the following input parameters:
\itemize{
\item{\code{type} }{ A string that declares the type of the body for the exact sampling: a) \code{'unit_simplex'} for the unit simplex, b) \code{'canonical_simplex'} for the canonical simplex, c) \code{'hypersphere'} for the boundary of a hypersphere centered at the origin, d) \code{'ball'} for the interior of a hypersphere centered at the origin.}
\item{\code{dimension} }{ An integer that declares the dimension when exact sampling is enabled for a simplex or a hypersphere.}
\item{\code{radius} }{ The radius of the \eqn{d}-dimensional hypersphere. The default value is \eqn{1}.}
}}

\item{n}{The number of points that the function is going to sample.}

\item{seed}{Optional. A fixed seed for the number generator.}
}
\value{
A \eqn{d\times n} matrix that contains, column-wise, the sampled points from the convex polytope P.
}
\description{
The \eqn{d}-dimensional unit simplex is the set of points \eqn{\vec{x}\in \R^d}, s.t.: \eqn{\sum_i x_i\leq 1}, \eqn{x_i\geq 0}. The \eqn{d}-dimensional canonical simplex is the set of points \eqn{\vec{x}\in \R^d}, s.t.: \eqn{\sum_i x_i = 1}, \eqn{x_i\geq 0}.
}
\examples{
# 100 uniform points from the 2-d unit ball
points = direct_sampling(n = 100, body = list("type" = "ball", "dimension" = 2))
}
\references{
\cite{R.Y. Rubinstein and B. Melamed,
\dQuote{Modern simulation and modeling} \emph{ Wiley Series in Probability and Statistics,} 1998.}

\cite{A Smith, Noah and W Tromble, Roy,
\dQuote{Sampling Uniformly from the Unit Simplex,} \emph{ Center for Language and Speech Processing Johns Hopkins University,} 2004.}
}
