% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{InnerBall}
\alias{InnerBall}
\title{Compute an inscribed ball of a convex polytope}
\usage{
InnerBall(P)
}
\arguments{
\item{P}{A convex polytope. It is an object from class (a) Hpolytope or (b) Vpolytope or (c) Zonotope.}
}
\value{
A \eqn{d+1}-dimensional vector that describes the inscribed ball. The first \eqn{d} coordinates corresponds to the center of the ball and the last one to the radius.
}
\description{
For a H-polytope described by a \eqn{m\times d} matrix \eqn{A} and a \eqn{m}-dimensional vector \eqn{b}, s.t.: \eqn{Ax\leq b}, this function computes the largest inscribed ball (Chebychev ball) by solving the corresponding linear program.
For a V-polytope \eqn{d+1} vertices, that define a full dimensional simplex, picked at random and the largest inscribed ball of the simplex is computed.
For a zonotope \eqn{P} we compute the minimum \eqn{r} s.t.: \eqn{ r e_i \in P} for all \eqn{i=1, \dots ,d}. Then the ball centered at the origin with radius \eqn{r/ \sqrt{d}} is an inscribed ball.
}
\examples{
# compute the Chebychev ball of the 2d unit simplex
P = GenSimplex(2,'H')
ball_vec = InnerBall(P)

# compute an inscribed ball of the 3-dimensional unit cube in V-representation
P = GenCube(3, 'V')
ball_vec = InnerBall(P)
}
