% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volcano_trio.R
\name{volcano_trio}
\alias{volcano_trio}
\title{Volcano Plots for a three-way comparison}
\usage{
volcano_trio(
  polar,
  p_cutoff = 0.05,
  fc_cutoff = 1,
  label_rows = NULL,
  label_size = 3,
  text_size = 10,
  marker_size = 0.7,
  shared_legend_size = 1,
  sig_names = NULL,
  colours = c("grey60", "salmon", "steelblue", "limegreen"),
  fc_line = TRUE,
  p_line = TRUE,
  line_colours = c("black", "black"),
  share_axes = TRUE
)
}
\arguments{
\item{polar}{A polar object with the pvalues between groups of interest.
Created by \code{\link{polar_coords}}.}

\item{p_cutoff}{The cut-off for pvalue significance (default = 0.05).}

\item{fc_cutoff}{The cut-off for fold change significance (default = 1).}

\item{label_rows}{Row numbers or names of values to be annotated/labelled
(default = NULL).}

\item{label_size}{The font size of labels (default = 3)}

\item{text_size}{The font size of text (default = 10)}

\item{marker_size}{The size of markers (default = 0.7)}

\item{shared_legend_size}{The size for the legend (default = 1).}

\item{sig_names}{A character vector of labels to be used for:
non-significant; adjusted p < p_cutoff; |Fold Change| > fc_cutoff; and
finally adjusted p < p_cutoff.
If NULL c('Not Significant', \code{paste('Padj <', `p_cutoff`)},
\code{paste('|FC| >', `fc_cutoff`)},
\code{paste('Padj <', `p_cutoff`, 'and |FC| >', `fc_cutoff`)}) is used.}

\item{colours}{A character vector of colours to be used for non-significant;
adjusted p < p_cutoff;
|Fold Change| >, fc_cutoff; and adjusted p < p_cutoff. default = p_cutoff &
|Fold Change| > fc_cutoff markers respectively
(default = c('grey60', 'salmon', 'steelblue', 'limegreen')).}

\item{fc_line}{Logical whether to add vertical dashed line at fc_cutoff
(default = TRUE).}

\item{p_line}{Logical whether to add horizontal dashed line at p_cutoff
(default = TRUE).}

\item{line_colours}{A character vector stating the colour of lines to be
used for fc_line and p_line respectively (default = c('black', 'black')).}

\item{share_axes}{Logical whether plots should share axes when plotted
together.}
}
\value{
Returns a list of ggplot volcano plots. The first three elements
contain comparisons between all contrasts. The last element in the list is a
combined figure for all three plots.
}
\description{
This function creates a volcano plot for all combinations of groups in a
factor.
}
\examples{
data(example_data)
syn_polar <- polar_coords(sampledata = syn_example_meta,
                          contrast = "Pathotype",
                          groups = NULL,
                          pvalues = syn_example_p,
                          expression = syn_example_rld,
                          p_col_suffix = "pvalue",
                          padj_col_suffix = "padj",
                          non_sig_name = "Not Significant",
                          multi_group_prefix = "LRT",
                          significance_cutoff = 0.01,
                          fc_col_suffix='log2FoldChange',
                          fc_cutoff = 0.3)
syn_volcano_plots <- volcano_trio(polar=syn_polar)
syn_volcano_plots$All
}
\references{
Lewis, Myles J., et al. (2019).
\href{https://www.cell.com/cell-reports/fulltext/S2211-1247(19)31007-1}{
Molecular portraits of early rheumatoid arthritis identify clinical and
treatment response phenotypes.}
\emph{Cell reports}, \strong{28}:9
}
\concept{volcanoplot}
\keyword{hplot}
