% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_features_py.R
\name{extract_features_py}
\alias{extract_features_py}
\title{Extract features from WAV audios using 'Python's' 'Parselmouth' library.}
\usage{
extract_features_py(
  directory,
  filesRange = 0,
  features = c("f0", "formants"),
  windowShift = 5/1000,
  full.names = TRUE,
  recursive = FALSE,
  round.to = NULL
)
}
\arguments{
\item{directory}{A directory/folder containing WAV files.}

\item{filesRange}{The desired range of directory files (default: 0, i.e., all files).}

\item{features}{Vector of features to be extracted. (default: 'f0' (pitch),'formants' (F1:F8)).}

\item{windowShift}{\code{= <dur>} set analysis window shift to <dur>ation in ms (default: 5/1000).}

\item{full.names}{Logical. If \code{TRUE}, the directory path is prepended to the file names to give a relative file path. If \code{FALSE}, the file names (rather than paths) are returned. (default: \code{TRUE})}

\item{recursive}{Logical. Should the listing recursively into directories? (default: \code{FALSE})}

\item{round.to}{Number of decimal places to round to. (default: \code{NULL})}
}
\value{
A data frame containing the selected features.
}
\description{
Extract features from WAV audios using 'Python's' 'Parselmouth' library.
}
\details{
The function uses the \code{getwd()} folder to write the temp files.
}
\examples{

\dontrun{
library(voice)

path2wav <- list.files(system.file('extdata', package = 'wrassp'),
pattern <- glob2rx('*.wav'), full.names = TRUE)
efp <- extract_features_py(dirname(path2wav))
efp
table(efp$file_name)

# limiting filesRange
efpl <- extract_features_py(dirname(path2wav), filesRange = 3:6)
efpl
table(efpl$file_name)
}
}
