% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evppi_gam.R
\name{all_interactions}
\alias{all_interactions}
\title{Generate a string with all interactions of a certain degree, to be used in a GAM formula}
\usage{
all_interactions(x, degree = 2)
}
\arguments{
\item{x}{Character vector of variable names}

\item{degree}{Maximum interaction degree}
}
\value{
A string looking like the right hand side of a GAM formula with tensor product interactions.

For example, if \code{x} is \code{c("x1","x2","x3")}, then \code{all_interactions(x, degree=2)} should return

\code{"te(x1,x2) + te(x1,x3) + te(x1,x3)"}
}
\description{
Generate a string with all interactions of a certain degree, to be used in a GAM formula
}
\examples{
x <- c("x1","x2","x3")
all_interactions(x, 2)

}
