
#' DCF indicators GUI
#'
#' The \code{gui_dcf_ind} function implements the graphical user interface for the
#'  DCF indicators computation routine.
#'
#' This function,  with a count vector generated by \code{\link{gui_out_grid}},
#'  computes the DCF indicators 5 and 6.
#'
#' @return This function does not return a value.
#'
#' @usage gui_dcf_ind()
#'
#'
#' @seealso \code{\link{gui_out_grid}}
#'
#' @references
#' Russo, T., Parisi, A., & Cataudella, S. (2013). Spatial indicators of fishing pressure: Preliminary analyses and possible developments. \emph{Ecological indicators}, \bold{26}, 141--153.
#' \url{http://www.sciencedirect.com/science/article/pii/S1470160X12003822}

gui_dcf_ind <- function() {
  grid_vec_file <- ""

  dcf_ind_win <- gwindow(
    title = "Data Collection Framework Indicators",
    visible = FALSE
  )

  big_g <- ggroup(horizontal = FALSE, container = dcf_ind_win)

  g_input <- ggroup(horizontal = TRUE, container = big_g)
  addSpring(g_input)
  grid_vec_f <- gframe(text = "Grid Count Vector", horizontal = TRUE, container = g_input)
  addSpring(grid_vec_f)
  sel_vec_f <- glabel("Select file", container = grid_vec_f)
  addSpring(grid_vec_f)
  gimage(system.file("ico/folder-green.png", package = "vmsbase"),
    container = grid_vec_f,
    handler = function(h, ...) {
      grid_vec_file <<- gfile(
        text = "Select Grid Count vector file",
        type = "open",
        filter = list("Grid Count file" = list(patterns = c("*.grivec.rData")))
      )
      svalue(sel_vec_f) <- ifelse(.Platform$OS.type == "windows", strsplit(grid_vec_file, "\\\\")[[1]][length(strsplit(grid_vec_file, "\\\\")[[1]])], strsplit(grid_vec_file, "/")[[1]][length(strsplit(grid_vec_file, "/")[[1]])])
      if (grid_vec_file != "") {
        enabled(start_b) <- TRUE
      }
    }
  )
  gimage(system.file("ico/application-exit-5.png", package = "vmsbase"),
    container = grid_vec_f,
    handler = function(h, ...) {
      grid_vec_file <<- ""
      enabled(start_b) <- FALSE
      svalue(sel_vec_f) <- "Select file"
    }
  )
  addSpring(g_input)
  addSpace(big_g, 10, horizontal = FALSE)
  g_inputb <- ggroup(horizontal = TRUE, container = big_g)
  addSpring(g_inputb)
  glabel("Cell Area", container = g_inputb)
  u_cel_dim <- gspinbutton(
    from = 0, to = 10, by = 0.25, value = 1, digits = 2,
    container = g_inputb
  )
  addSpring(g_inputb)

  addSpring(big_g)
  g_output <- ggroup(horizontal = FALSE, container = big_g)
  addSpring(g_output)
  dcff_l <- glabel("", container = g_output)
  dcfs_l <- glabel("", container = g_output)
  addSpring(g_output)

  addSpring(big_g)
  start_b <- gbutton("Calculate\nDCF Indicators", container = big_g, handler = function(h, ...) {
    enabled(g_input) <- FALSE
    enabled(g_inputb) <- FALSE
    svalue(dcff_l) <- ""
    svalue(dcfs_l) <- ""
    grid_vec <- readRDS(grid_vec_file)
    tot_v <- sum(grid_vec)
    tot_f <- length(which(grid_vec > 0))
    top_n <- tot_v * 0.90
    svalue(dcff_l) <- paste("DCF 5: ", tot_f * svalue(u_cel_dim), sep = "")
    ord_si <- sort(grid_vec, decreasing = T)
    ord_su <- cumsum(ord_si)
    top_s <- length(which(ord_su < top_n))
    svalue(dcfs_l) <- paste("DCF 6: ", top_s * svalue(u_cel_dim), sep = "")
    enabled(g_input) <- TRUE
    enabled(g_inputb) <- TRUE
  })
  enabled(start_b) <- FALSE

  visible(dcf_ind_win) <- TRUE
}
