% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/af_distribution.R
\name{af_distribution}
\alias{af_distribution}
\title{af_distribution}
\usage{
af_distribution(df)
}
\arguments{
\item{df}{A dataframe that has been arranged (arrange_data) and filtered (filter_variants)}
}
\value{
plots with the distribution of all minor variants
}
\description{
Plots distribution of all minor variants
}
\examples{
# Example 1:
df <- data.frame(sample = c("m1", "m2", "m1", "m2", "m1"),
                 CHROM = c("PB1", "PB1", "PB2", "PB2", "NP"),
                 POS = c(234, 234, 240, 240, 254),
                 REF = c("G", "G", "A", "A", "C"),
                 ALT = c("A", "A", "G", "G", "T"),
                 minorfreq = c(0.010, 0.022, 0.043, 0.055, 0.011),
                 majorfreq = c(0.990, 0.978, 0.957, 0.945, 0.989),
                 minorcount = c(7, 15, 26, 32, 7),
                 majorcount = c(709, 661, 574, 547, 610),
                 gt_DP = c(716, 676, 600, 579, 617)
)

af_distribution(df)

# Example 2:
af_distribution(example_filtered_SNV_df)

}
