#' Simulated normal data
#' @format A data frame with 200 rows and 10 variables:
#' \describe{
#'   \item{a}{variable a}
#'   \item{b}{variable b}
#'   \item{c}{variable c}
#'   \item{d}{variable d}
#'   \item{e}{variable e}
#'   \item{f}{variable f}
#'   \item{g}{variable g}
#'   \item{h}{variable h}
#'   \item{i}{variable i}
#'   \item{j}{variable j}
#' }
#' @source package author
"normal_df"

#' Simulated normal data with annotations
#' @format A data frame with 200 rows and 10 variables:
#' \describe{
#'   \item{a}{variable a}
#'   \item{b}{variable b}
#'   \item{c}{variable c}
#'   \item{d}{variable d}
#'   \item{e}{variable e}
#'   \item{f}{variable f}
#'   \item{g}{variable g}
#'   \item{h}{variable h}
#'   \item{i}{variable i}
#'   \item{j}{variable j}
#'   \item{annot}{annotation column}
#' }
#' @source package author
"normal_annotated"

#' Simulated normal data with missing values
#' @format A data frame with 200 rows and 10 variables:
#' \describe{
#'   \item{a}{variable a}
#'   \item{b}{variable b}
#'   \item{c}{variable c}
#'   \item{d}{variable d}
#'   \item{e}{variable e}
#'   \item{f}{variable f}
#'   \item{g}{variable g}
#'   \item{h}{variable h}
#'   \item{i}{variable i}
#'   \item{j}{variable with randomly missing values}
#' }
#' @source package author
"normal_missing"

#' Simulated logscaled data
#' @format A data frame with 200 rows and 10 variables:
#' \describe{
#'   \item{a}{variable a}
#'   \item{b}{variable b}
#'   \item{c}{variable c}
#'   \item{d}{variable d}
#'   \item{e}{variable e}
#'   \item{f}{variable f}
#'   \item{g}{variable g}
#'   \item{h}{variable h}
#'   \item{i}{variable i}
#'   \item{j}{variable j}
#' }
#' @source package author
"logscaled_df"

#' Simulated binary data
#' @format A data frame with 200 rows and 10 variables:
#' \describe{
#'   \item{a}{variable a}
#'   \item{b}{variable b}
#'   \item{c}{variable c}
#'   \item{d}{variable d}
#'   \item{e}{variable e}
#'   \item{f}{variable f}
#'   \item{g}{variable g}
#'   \item{h}{variable h}
#'   \item{i}{variable i}
#'   \item{j}{variable j}
#' }
#' @source package author
"bin_df"
