% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_input.R
\name{validate_input}
\alias{validate_input}
\title{Validate input data}
\usage{
validate_input(data, start, end, events, groups, linewidth, title,
  showLabels, lineInterval, background_lines)
}
\arguments{
\item{data}{the data}

\item{start}{start dates}

\item{end}{end dates}

\item{events}{event column name}

\item{groups}{group column name}

\item{linewidth}{width of range lines}

\item{title}{plot title}

\item{showLabels}{boolean}

\item{lineInterval}{deprecated, replaced by background_lines}

\item{background_lines}{interval of grey background lines}
}
\value{
the data frame with possibly new or renamed columns, or an error
}
\description{
Validate input data
}
\examples{
\dontrun{
validate_input(data.frame(event = 1:2, start = c(Sys.Date(), Sys.Date() + 1)),
               events="event", start="start", end="end", groups="group",
               linewidth=NULL, title=NULL, showLabels = TRUE,
               lineInterval=NULL, background_lines = 11)
}
}
