% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{juliaNormal}
\alias{juliaNormal}
\title{Julia iteration with a given number of steps}
\usage{
juliaNormal(z, c, R_esc, itDepth = 500L)
}
\arguments{
\item{z}{Complex number; the point in the complex plane to which the output
of the function is mapped}

\item{c}{Complex number; a parameter whose choice has an enormous effect on
the shape of the Julia set. For obtaining useful results with
\code{\link{phasePortrait}}, \code{c} must be an element of the Mandelbrot
set.}

\item{R_esc}{Real number; the espace radius. If the absolute value of a
number obtained during iteration attains or excels the value of
\code{R_esc}, \code{juliaNormal} will return \code{NaN+NaNi}. \code{R_esc
= 2} is a good choice for \code{c} being an element of the Mandelbrot set.
See Details for more information.}

\item{itDepth}{An integer which defines the depth of the iteration, i.e. the
maximum number of iteration (default: \code{itDepth =  500})}
}
\value{
Either \code{NaN+NaNi} or the complex number obtained after
  \code{itDepth} iterations
}
\description{
This function is designed as the basis for visualizing normal Julia sets
with \code{\link{phasePortrait}}. In contrast to usual visualizations of
Julia sets, this requires coloring the actual member points of the set and
not the points outside. Therefore, for numbers that can be identified as not
being parts of the Julia set, this function returns \code{NaN+NaNi}. All
other numbers are mapped to the complex value obtained after a user-defined
number of iterations. This function has been implemented in C++; therefore
it is fairly fast.
}
\details{
Normal Julia sets are closely related to the Mandelbrot set. A normal Julia
set comprises all complex numbers \code{z} for which the following sequence
is bounded for all \code{n > 0}: \code{a[n+1] = a[n]^2 + c}, starting with
\code{a[0] = z}. The parameter \code{c} is a complex number, and the
sequence is certainly unbounded if \code{abs(a[]) >= R} with \code{R} being
an escape Radius which matches the inequality \code{R^2 - R >= abs(c)}. As
the visualization with this package gives interesting pictures (i.e. other
than a blank screen) only for \code{c} which are elements of the Mandelbrot
set, \code{R = 2} is a good choice. For the author's taste, the Julia
visualizations become most interesting for \code{c} located in the border
zone of the Mandelbrot set.
}
\examples{
# This code visualizes a Julia set with some appeal (for the author's
# taste). Zoom in as you like by adjusting xlim and ylim.
\donttest{
phasePortrait(juliaNormal,
  moreArgs = list(c = -0.09 - 0.649i, R_esc = 2),
  xlim = c(-2, 2),
  ylim = c(-1.3, 1.3),
  hsvNaN = c(0, 0, 0),
  nCores = 1)          # Max. two cores on CRAN, not a limit for your use
  \dontshow{
  # R CMD check: make sure any open connections are closed afterward
  foreach::registerDoSEQ()
  doParallel::stopImplicitCluster()
  }
}


}
\seealso{
Other fractals: 
\code{\link{mandelbrot}()}

Other maths: 
\code{\link{blaschkeProd}()},
\code{\link{jacobiTheta}()},
\code{\link{mandelbrot}()}
}
\concept{fractals}
\concept{maths}
