% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heat_map.R
\name{heat_map}
\alias{heat_map}
\title{heat_map}
\usage{
heat_map(
  data,
  xAccessor,
  yAccessor,
  valueAccessor,
  mainTitle = "",
  subTitle = "",
  accessibility = list(),
  props = list(),
  ...
)
}
\arguments{
\item{data}{required to be a valid, R data frame. Data used to create chart, an array of objects which includes keys that map to chart accessors.}

\item{xAccessor}{String. Key used to determine the x-axis categorical value. (similar to x in ggplot)}

\item{yAccessor}{String. Key used to determine the y-axis categorical value. (similar to y in ggplot)}

\item{valueAccessor}{String. Key used to determine heatmap's numeric property, for assigning color.}

\item{mainTitle}{String. The dynamic tag of title for the map (or you can create your own separately). See \code{highestHeadingLevel} prop for how tags get assigned.}

\item{subTitle}{String. The dynamic tag for a sub title for the map (or you can create your own separately). See \code{highestHeadingLevel} prop for how tags get assigned.}

\item{accessibility}{List(). Manages messages and settings for chart accessibility, see \href{https://github.com/visa/visa-chart-components/tree/master/packages/heat-map#accessibility-props}{object definition}}

\item{props}{List(). A valid R list with additional property configurations, see all props for \href{https://github.com/visa/visa-chart-components/tree/master/packages/heat-map}{@visa/heat-map}}

\item{...}{All other props passed into the function will be passed through to the chart, see all props for \href{https://github.com/visa/visa-chart-components/tree/master/packages/heat-map}{@visa/heat-map}.}
}
\value{
a visaChart htmlwidget object for plotting a heat map
}
\description{
R wrapper for \href{https://github.com/visa/visa-chart-components/tree/master/packages/heat-map}{@visa/heat-map} via \href{https://www.htmlwidgets.org/}{htmlwidgets}.

Here is an example of heat-map in action:

\if{html}{\figure{heat-map-1.png}{options: width=400 alt="example heat map"}}
}
\details{
To see all available options for the chart properties/API see \href{https://github.com/visa/visa-chart-components/tree/master/packages/heat-map}{@visa/heat-map}.
}
\examples{
library(tidyverse)
data.frame(UCBAdmissions) \%>\%
  filter(Admit == "Rejected") \%>\%
  heat_map("Dept","Gender", "Freq")
}
