% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visOptions.R
\name{visOptions}
\alias{visOptions}
\title{Network visualization general options}
\usage{
visOptions(graph, width = NULL, height = NULL,
  highlightNearest = FALSE, nodesIdSelection = FALSE,
  selectedBy = NULL, collapse = FALSE, autoResize = NULL,
  clickToUse = NULL, manipulation = NULL)
}
\arguments{
\item{graph}{: a visNetwork object}

\item{width}{: String. Default to "100\%". The width of the network in pixels or as a percentage.}

\item{height}{: String. Default to "100\%". The height of the network in pixels or as a percentage.}

\item{highlightNearest}{: Custom Option. Just a Boolean, or a named list. Default to false. Highlight nearest when clicking a node ? Not available for DOT and Gephi.
\itemize{
 \item{"enabled"}{ : Boolean. Default to false. Activated or not ?.}
 \item{"degree"}{ : Optional. Integer. Degree of depth of nodes to be colored. Default to 1. Set high number to have the entire sub-network. In case of "hierarchical" algorithm, you can also pass a list(from = 1, to = 1) to control degree in both direction}
 \item{"hover"}{ : Optional. Boolean. Enable highlightNearest alos hovering a node ? Default to FALSE}
 \item{"algorithm"}{ : Optional. String. highlightNearest algorithm. "all" highlight all nodes, without taking direction information. "hierarchical" look only at inputs/outputs nodes.}
 \item{"hideColor"}{ : Optional. String. Color for hidden nodes/edges. Use a rgba definition. Defaut to rgba(200,200,200,0.5)}
 \item{"labelOnly"}{ : Optional. Boolean. Keep just label for nodes on degree + 1 ? Default to TRUE}
}}

\item{nodesIdSelection}{:  Custom Option. Just a Boolean, or a named list. Default to false. Add an id node selection creating an HTML select element. This options use click event. Not available for DOT and Gephi.
\itemize{
 \item{"enabled"}{ : Boolean. Default to false. Activated or not ?.}
 \item{"values}{ : Optional. Vector of possible values (node's id), and so order is preserve. Defaut to all id in nodes data.frame.}
 \item{"selected"}{ : Optional. Integer/Character. Initial id selection. Defaut to NULL}
 \item{"style"}{ : Optional. Character. HTML style of list. Default to 'width: 150px; height: 26px'.}
 \item{"useLabels"}{ : Optional. Boolean. Use labels instead of id ? Default to TRUE.}
 \item{"main"}{ : Optional. Default to "Select by id"}
}}

\item{selectedBy}{: Custom option. Character or a named list. Add a multiple selection based on column of node data.frame creating an HTML select element. Not available for DOT and Gephi.
\itemize{
 \item{"variable"}{ : Character. Column name of selection variable.}
 \item{"values}{ : Optional. Vector of possible values. Defaut to all values in nodes data.frame.}
 \item{"selected"}{ : Optional. Integer/Character. Initial selection. Defaut to NULL}
 \item{"style"}{ : Optional. Character. HTML style of list. Default to 'width: 150px; height: 26px'.}
 \item{"multiple"}{ : Optional. Boolean. Default to FALSE. If TRUE, you can affect multiple groups per nodes using a comma ("gr1,gr2")}
 \item{"hideColor"}{ : Optional. String. Color for hidden nodes/edges. Use a rgba definition. Defaut to rgba(200,200,200,0.5)}
 \item{"main"}{ : Optional. Default to "Select by variable"}
 \item{"sort"}{ : Optional. If values is NULL, sort all possible values ?. Defaut to TRUE}
}}

\item{collapse}{: Custom option. Just a Boolean, or a named list. Collapse / Uncollapse nodes using double-click. In dev.
\itemize{
 \item{"enabled"}{ : Boolean. Default to false. Activated or not ?}
 \item{"fit"}{ : Optional. Boolean. Default to FALSE. Call fit method after collapse/uncollapse event ?}
 \item{"resetHighlight"}{ : Optional. Boolean. Default to TRUE to reset highlighted nodes after collapse/uncollapse event.}
 \item{"clusterOptions"}{ : Optional. List. Defaut to NULL. A list of all options you want to pass to cluster collapsed node}
 \item{"keepCoord"}{ : Optional. Boolean. Default to TRUE to keep nodes coordinates on collapse}
 \item{"labelSuffix"}{ : Optional. Character. Use node label + suffix or just suffix. Default to '(cluster)'}
}}

\item{autoResize}{: Boolean. Default to true. If true, the Network will automatically detect when its container is resized, and redraw itself accordingly. If false, the Network can be forced to repaint after its container has been resized using the function redraw() and setSize().}

\item{clickToUse}{: Boolean. Default to false. When a Network is configured to be clickToUse, it will react to mouse, touch, and keyboard events only when active. When active, a blue shadow border is displayed around the Network. The Network is set active by clicking on it, and is changed to inactive again by clicking outside the Network or by pressing the ESC key.}

\item{manipulation}{: Just a Boolean or a list. See \link{visDocumentation}}
}
\description{
Network visualization general options. For full documentation, have a look at \link{visDocumentation}.
}
\examples{
nodes <- data.frame(id = 1:15, label = paste("Label", 1:15),
 group = sample(LETTERS[1:3], 15, replace = TRUE))

edges <- data.frame(from = trunc(runif(15)*(15-1))+1,
 to = trunc(runif(15)*(15-1))+1)
 
###################  
# highlight nearest
###################

visNetwork(nodes, edges) \%>\% visOptions(highlightNearest = TRUE)
visNetwork(nodes, edges) \%>\% visOptions(highlightNearest = list(enabled = TRUE, degree = 2))

# also when hover a node ?
visNetwork(nodes, edges) \%>\% visOptions(highlightNearest = list(enabled = TRUE, hover = TRUE))

# don't show nodes/edges
visNetwork(nodes, edges) \%>\% visOptions(highlightNearest = list(enabled = TRUE, 
 hover = TRUE, hideColor = 'rgba(200,200,200,0)'))

# Using hierarchical information
nodes = data.frame(id = 1:6, level = c(1, 2, 3, 3, 4, 2))
edges = data.frame(from = c(1, 2, 2, 4, 6), to = c(2, 3, 4, 5, 4))

visNetwork(nodes, edges) \%>\% visHierarchicalLayout() \%>\% visEdges(arrows = "to") \%>\% 
 visOptions(highlightNearest = list(enabled = TRUE, algorithm = "hierarchical"))
 
visNetwork(nodes, edges) \%>\% visHierarchicalLayout() \%>\% visEdges(arrows = "to") \%>\% 
 visOptions(highlightNearest = list(enabled = TRUE, algorithm = "hierarchical", 
   degree = list(from = 0, to = 2)))
   
##########################
# nodesIdSelection
##########################
 
visNetwork(nodes, edges) \%>\% 
 visOptions(highlightNearest = TRUE, nodesIdSelection = TRUE)

# add a default selected node ?
visNetwork(nodes, edges) \%>\% 
 visOptions(highlightNearest = TRUE, 
 nodesIdSelection = list(enabled = TRUE, selected = "1"))
 
# subset on id values & don't use labels ?
visNetwork(nodes, edges) \%>\% 
 visOptions(highlightNearest = TRUE, 
 nodesIdSelection = list(enabled = TRUE, 
   selected = "2", values = c(2:10), useLabels = FALSE))
 
# some style
visNetwork(nodes, edges) \%>\% 
 visOptions(highlightNearest = TRUE, 
 nodesIdSelection = list(enabled = TRUE, style = 'width: 200px; height: 26px;
   background: #f8f8f8;
   color: darkblue;
   border:none;
   outline:none;'))   
 
##########################
# collapse
##########################
 
nodes <- data.frame(id = 1:15, label = paste("Label", 1:15),
 group = sample(LETTERS[1:3], 15, replace = TRUE))

edges <- data.frame(from = trunc(runif(15)*(15-1))+1,
 to = trunc(runif(15)*(15-1))+1)
 
# keeping all parent node attributes  
visNetwork(nodes, edges) \%>\% visEdges(arrows = "to") \%>\%
 visOptions(collapse = TRUE)

# setting some properties  
visNetwork(nodes, edges) \%>\% visEdges(arrows = "to") \%>\%
 visOptions(collapse = list(enabled = TRUE, clusterOptions = list(shape = "square"))) 
   
# enable / disable open cluster (proxy only) : 
# visEvents(type = "off", doubleClick = "networkOpenCluster")
# visEvents(type = "on", doubleClick = "networkOpenCluster")  
 
##########################
# selectedBy
##########################
nodes <- data.frame(id = 1:15, label = paste("Label", 1:15),
 group = sample(LETTERS[1:3], 15, replace = TRUE))

edges <- data.frame(from = trunc(runif(15)*(15-1))+1,
 to = trunc(runif(15)*(15-1))+1)
 
visNetwork(nodes, edges) \%>\% 
 visOptions(selectedBy = "group")
 
# add a default value ?
visNetwork(nodes, edges) \%>\% 
 visOptions(selectedBy = list(variable = "group", selected = "A"))

# subset on values ?
visNetwork(nodes, edges) \%>\% 
 visOptions(selectedBy = list(variable = "group", 
   selected = "C",
   values = c("A", "C")))
 
# add some style
visNetwork(nodes, edges) \%>\% 
 visOptions(selectedBy = list(variable = "group", style = 'width: 200px; height: 26px;
   background: #f8f8f8;
   color: darkblue;
   border:none;
   outline:none;'))
     
# can also be on new column
nodes$sample <- sample(c("sample 1", "sample 2"), nrow(nodes), replace = TRUE)
visNetwork(nodes, edges) \%>\% 
 visOptions(selectedBy = "sample")

# and with multiple groups ?
nodes$group <- sample(c("group 1", "group 2", "group 1, group 2, group 3"), 
 nrow(nodes), replace = TRUE)
 
visNetwork(nodes, edges) \%>\% 
 visOptions(selectedBy = list(variable = "group", multiple = TRUE))
 
##########################
# manipulation
##########################
 
visNetwork(nodes, edges) \%>\% 
 visOptions(manipulation = TRUE)

visNetwork(nodes, edges) \%>\% 
 visOptions(manipulation = list(enabled = TRUE, addNode = FALSE, addEdge = FALSE))

visNetwork(nodes, edges) \%>\% 
 visOptions(manipulation = list(enabled = TRUE, deleteNode = FALSE, deleteEdge = FALSE))

visNetwork(nodes, edges) \%>\% 
 visOptions(manipulation = list(enabled = TRUE, editNode = FALSE, editEdge = FALSE))

visNetwork(nodes, edges)  \%>\% 
 visOptions(manipulation = list(enabled = TRUE, 
                                editEdge = htmlwidgets::JS("function(data, callback) {
                                                           console.info('edit edge')
                                                           }")
                                    )
                                )
##########################
# collapse
##########################
visNetwork(nodes, edges) \%>\% 
 visEdges(arrows = "to") \%>\% 
 visOptions(collapse = list(enabled = TRUE, 
   clusterOptions = list(shape = "square")))
  
}
\references{
See online documentation \url{http://datastorm-open.github.io/visNetwork/}
}
\seealso{
\link{visNodes} for nodes options, \link{visEdges} for edges options, \link{visGroups} for groups options, 
\link{visLegend} for adding legend, \link{visOptions} for custom option, \link{visLayout} & \link{visHierarchicalLayout} for layout, 
\link{visPhysics} for control physics, \link{visInteraction} for interaction, \link{visNetworkProxy} & \link{visFocus} & \link{visFit} for animation within shiny,
\link{visDocumentation}, \link{visEvents}, \link{visConfigure} ...
}
