% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visNodes.R
\name{visNodes}
\alias{visNodes}
\title{Network visualization nodes options}
\usage{
visNodes(graph, id = NULL, shape = NULL, size = NULL, title = NULL,
  value = NULL, x = NULL, y = NULL, label = NULL, level = NULL,
  group = NULL, hidden = NULL, image = NULL, mass = NULL,
  physics = NULL, borderWidth = NULL, borderWidthSelected = NULL,
  brokenImage = NULL, labelHighlightBold = NULL, color = NULL,
  fixed = NULL, font = NULL, icon = NULL, shadow = NULL,
  scaling = NULL, shapeProperties = NULL)
}
\arguments{
\item{graph}{: a visNetwork object}

\item{id}{: String. Default to undefined. The id of the node. The id is mandatory for nodes and they have to be unique. This should obviously be set per node, not globally.}

\item{shape}{: String. Default to 'ellipse'. The shape defines what the node looks like. There are two types of nodes. One type has the label inside of it and the other type has the label underneath it. The types with the label inside of it are: ellipse, circle, database, box, text. The ones with the label outside of it are: image, circularImage, diamond, dot, star, triangle, triangleDown, square and icon.}

\item{size}{: Number. Default to 25. The size is used to determine the size of node shapes that do not have the label inside of them. These shapes are: image, circularImage, diamond, dot, star, triangle, triangleDown, square and icon}

\item{title}{: String or Element. Default to undefined. Title to be displayed when the user hovers over the node. The title can be an HTML element or a string containing plain text or HTML.}

\item{value}{: Number. Default to undefined. When a value is set, the nodes will be scaled using the options in the scaling object defined above.}

\item{x}{: Number. Default to undefined. This gives a node an initial x position. When using the hierarchical layout, either the x or y position is set by the layout engine depending on the type of view. The other value remains untouched. When using stabilization, the stabilized position may be different from the initial one. To lock the node to that position use the physics or fixed options.}

\item{y}{: Number. Default to undefined. This gives a node an initial y position. When using the hierarchical layout, either the x or y position is set by the layout engine depending on the type of view. The other value remains untouched. When using stabilization, the stabilized position may be different from the initial one. To lock the node to that position use the physics or fixed options.}

\item{label}{: String. Default to undefined. The label is the piece of text shown in or under the node, depending on the shape.}

\item{level}{: Number. Default to undefined. When using the hierarchical layout, the level determines where the node is going to be positioned.}

\item{group}{: String. Default to undefined. When not undefined, the group of node(s)}

\item{hidden}{: Boolean. Default to false. When true, the node will not be shown. It will still be part of the physics simulation though!}

\item{image}{: String. Default to undefined. When the shape is set to image or circularImage, this option should be the URL to an image. If the image cannot be found, the brokenImage option can be used.}

\item{mass}{: Number. Default to 1. The barnesHut physics model (which is enabled by default) is based on an inverted gravity model. By increasing the mass of a node, you increase it's repulsion. Values lower than 1 are not recommended.}

\item{physics}{: Boolean. Default to true. When false, the node is not part of the physics simulation. It will not move except for from manual dragging.}

\item{borderWidth}{: Number. Default to 1. The width of the border of the node when it is not selected, automatically limited by the width of the node.}

\item{borderWidthSelected}{: Number. Default to 2. The width of the border of the node when it is selected. If left at undefined, double the borderWidth will be used.}

\item{brokenImage}{: String. Undefined. When the shape is set to image or circularImage, this option can be an URL to a backup image in case the URL supplied in the image option cannot be resolved}

\item{labelHighlightBold}{: Boolean. Default to true. Determines whether or not the label becomes bold when the node is selected.}

\item{color}{: String | named list.    Color for the node. Can be just one color, or a list with several elements :
\itemize{
 \item{"background"}{ : String. Default to '#97C2FC'. Background color for the node.}
 \item{"border"}{ : String. Default to '#2B7CE9'. Border color for the node.}
 \item{"highlight"}{ : String | named list,     Color of the node when selected.
   \itemize{
     \item{"background"}{ : String. Default to '#97C2FC'. Background color for the node when selected.}
     \item{"border"}{ : String. Default to '#2B7CE9'. Border color for the node when selected.}
   }
 }
 \item{"hover"}{ : named list, when the hover option is enabled
   \itemize{
     \item{"background"}{ : String. Default to '#2B7CE9'. Border color of the node when selected.}
     \item{"border"}{ : String. Default to '#2B7CE9'. Border color of the node when the node is hovered over and the hover option is enabled.}
   }
 }
}}

\item{fixed}{: Boolean | named list. Default to false. When true, the node will not move but IS part of the physics simulation. When defined as an list, movement in either X or Y direction can be disabled.
\itemize{
 \item{"x"}{ : Boolean. When true, the node will not move in the X direction.}
 \item{"y"}{ : Boolean. When true, the node will not move in the Y direction.}
}}

\item{font}{: Named list or String. This object defines the details of the label. A shorthand is also supported in the form 'size face color' for example: '14px arial red'
\itemize{
 \item{"color"}{ : String. Default to '#343434'. Color of the label text.}
 \item{"size"}{ : Number. Default to 14. Size of the label text.}
 \item{"face"}{ : String. Default to 'arial. Font face (or font family) of the label text.}
 \item{"background"}{ : String. Default to undefined. When not undefined but a color string, a background rectangle will be drawn behind the label in the supplied color.}
 \item{"strokeWidth"}{ : Number. Default to 0. As an alternative to the background rectangle, a stroke can be drawn around the text. When a value higher than 0 is supplied, the stroke will be drawn.}
 \item{"strokeColor"}{ : String. Default to '#ffffff'. This is the color of the stroke assuming the value for stroke is higher than 0.}
}}

\item{icon}{: Named list. These options are only used when the shape is set to 'icon'.
\itemize{
 \item{"face"}{ : String. Default to 'FontAwesome'. These options are only used when the shape is set to icon. The possible options for the face are: 'FontAwesome' and 'Ionicons'.}
 \item{"code"}{ : String. Default to undefined. This is the code of the icon, for example '\\uf007'.}
 \item{"size"}{ : Number. Default to 50. The size of the icon.}
 \item{"color"}{ : String. Default to '#2B7CE9'. The color of the icon.}
}}

\item{shadow}{: Boolean | named list. Default to false. When true, the node casts a shadow using the default settings. This can be further refined by supplying a list
\itemize{
 \item{"enabled"}{ : Boolean. Default to false. Toggle the casting of shadows. If this option is not defined, it is set to true if any of the properties in this object are defined.}
 \item{"color"}{    : String. Default to    'rgba(0,0,0,0.5)'.    The color of the shadow as a string. Supported formats are 'rgb(255,255,255)', 'rgba(255,255,255,1)' and '#FFFFFF'.}
 \item{"size"}{ : Number. Default to 10. The blur size of the shadow.}
 \item{"x"}{ : Number. Default to 5. The x offset.}
 \item{"y"}{ : Number. Default to 5. The y offset.}
}}

\item{scaling}{: Named list.  If the value option is specified, the size of the nodes will be scaled according to the properties in this object.
\itemize{
 \item{"min"}{ :  Number. Default to 10. If nodes have a value, their sizes are determined by the value, the scaling function and the min max values.}
 \item{"max"}{ : Number. Default to 30. This is the maximum allowed size when the nodes are scaled using the value option.}
 \item{"label"}{ : Named list or Boolean. Default to Named list. This can be false if the label is not allowed to scale with the node. If true it will scale using default settigns. For further customization, you can supply an object.
   \itemize{
     \item{"enabled"}{ : Boolean. Default to false. Toggle the scaling of the label on or off. If this option is not defined, it is set to true if any of the properties in this object are defined.}
     \item{"min"}{ : Number. Default to 14. The minimum font-size used for labels when scaling.}
     \item{"max"}{ : Number. Default to 30. The maximum font-size used for labels when scaling.}
     \item{"maxVisible"}{ :   Number. Default to 30. When zooming in, the font is drawn larger as well. You can limit the perceived font size using this option. If set to 30, the font will never look larger than size 30 zoomed at 100\%.}
     \item{"drawThreshold"}{ : Number. Default to 5. When zooming out, the font will be drawn smaller. This defines a lower limit for when the font is drawn. When using font scaling, you can use this together with the maxVisible to first show labels of important nodes when zoomed out and only show the rest when zooming in.}
   }
 }
 \item{"customScalingFunction"}{ : Function. If nodes have value fields, this function determines how the size of the nodes are scaled based on their values.}
}}

\item{shapeProperties}{: Named list. This object contains configuration for specific shapes. 
\itemize{
 \item{"borderDashes"}{ : Vector or Boolean. Default to    false. This property applies to all shapes that have borders. You set the dashes by supplying an Vector Vector formart: [dash length, gap length]. You can also use a Boolean, false is disable and true is default [5,15].}
 \item{"borderRadius"}{ : Number. Default to    6. This property is used only for the box shape. It allows you to determine the roundness of the corners of the shape.}
 \item{"interpolation"}{ :     Boolean. Default to    true. This property only applies to the image and circularImage shapes. When true, the image is resampled when scaled down, resulting in a nicer image at the cost of computional time.}
 \item{"useImageSize"}{ : Boolean. Default to false. This property only applies to the image and circularImage shapes. When false, the size option is used, when true, the size of the image is used.}
 \item{"useBorderWithImage"}{ : Boolean. Default to false. This property only applies to the image shape. When true, the color object is used. A rectangle with the background color is drawn behind it and it has a border. This means all border options are taken into account.}
}}
}
\description{
Network visualization nodes options. For full documentation, have a look at \link{visDocumentation}.
}
\examples{
nodes <- data.frame(id = 1:3)
edges <- data.frame(from = c(1,2), to = c(1,3))

visNetwork(nodes, edges) \%>\% visNodes(shape = "square", title = "I'm a node", borderWidth = 3)

visNetwork(nodes, edges) \%>\% visNodes(color = list(hover = "green")) \%>\%
 visInteraction(hover = TRUE)

visNetwork(nodes, edges) \%>\% visNodes(color = "red")

visNetwork(nodes, edges) \%>\% visNodes(color = list(background = "red", border = "blue", 
 highlight = "yellow"))

visNetwork(nodes, edges) \%>\% visNodes(shadow = TRUE)

visNetwork(nodes, edges) \%>\% visNodes(shadow = list(enabled = TRUE, size = 50))


}
\references{
See online documentation \url{http://datastorm-open.github.io/visNetwork/}
}
\seealso{
\link{visNodes} for nodes options, \link{visEdges} for edges options, \link{visGroups} for groups options, 
\link{visLegend} for adding legend, \link{visOptions} for custom option, \link{visLayout} & \link{visHierarchicalLayout} for layout, 
\link{visPhysics} for control physics, \link{visInteraction} for interaction, \link{visNetworkProxy} & \link{visFocus} & \link{visFit} for animation within shiny,
\link{visDocumentation}, \link{visEvents}, \link{visConfigure} ...
}

