% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visFit.R
\name{visFit}
\alias{visFit}
\title{Network visualization fit method}
\usage{
visFit(graph, nodes = NULL, animation = list(duration = 1500, easingFunction
  = "easeInOutQuad"))
}
\arguments{
\item{graph}{: a \code{\link{visNetworkProxy}}  object}

\item{nodes}{: NULL for all nodes (Default), or a vector of nodes id}

\item{animation}{: Optional. List. For animation you can define the duration (in milliseconds) and easing function manually. 
Available are: linear, easeInQuad, easeOutQuad, easeInOutQuad, easeInCubic, easeOutCubic, easeInOutCubic, easeInQuart, easeOutQuart, easeInOutQuart, easeInQuint, easeOutQuint, easeInOutQuint.
Default to list(duration = 1500, easingFunction = "easeInOutQuad")}
}
\description{
For use fit() method in a shiny app. For full documentation, have a look at \link{visDocumentation}.
}
\examples{
\dontrun{

# have a look to : 
shiny::runApp(system.file("shiny", package = "visNetwork"))

}

}
\seealso{
\link{visNodes} for nodes options, \link{visEdges} for edges options, \link{visGroups} for groups options, 
\link{visLegend} for adding legend, \link{visOptions} for custom option, \link{visLayout} & \link{visHierarchicalLayout} for layout, 
\link{visPhysics} for control physics, \link{visInteraction} for interaction, \link{visNetworkProxy} & \link{visFocus} & \link{visFit} for animation within shiny,
\link{visDocumentation}, \link{visEvents}, \link{visConfigure} ...
}

