% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vimp_hypothesis_test.R
\name{vimp_hypothesis_test}
\alias{vimp_hypothesis_test}
\title{Perform a hypothesis test against the null hypothesis of \eqn{\delta} importance}
\usage{
vimp_hypothesis_test(
  full,
  reduced,
  y,
  folds,
  delta = 0,
  weights = rep(1, length(y)),
  type = "r_squared",
  alpha = 0.05,
  cv = FALSE,
  scale = "identity",
  na.rm = FALSE
)
}
\arguments{
\item{full}{either (i) fitted values from a regression of the outcome on the full set of covariates from a first independent split of the data (if \code{cv = FALSE}) or (ii) a list of predicted values from a cross-validated procedure (if \code{cv = TRUE}).}

\item{reduced}{fitted values from a regression either (1) of the outcome on the reduced set of covariates, or (2) of the predicted values from the full regression on the reduced set of covariates; either (i) a single set of predictions (if \code{cv = FALSE}) fit on an independent split of the data from \code{full} or (ii) a list of predicted values from a cross-validated procedure (if \code{cv = TRUE}).}

\item{y}{the outcome.}

\item{folds}{the folds used for splitting. If \code{cv = FALSE}, assumed to be a vector with 1 for the full regression and 2 for the reduced regression (if V = 2). If \code{cv = TRUE}, assumed to be a list with first element the outer folds (for hypothesis testing) and second element a list with the inner cross-validation folds.}

\item{delta}{the value of the \eqn{\delta}-null (i.e., testing if importance < \eqn{\delta}); defaults to 0.}

\item{weights}{weights for the computed influence curve (e.g., inverse probability weights for coarsened-at-random settings)}

\item{type}{which parameter are you estimating (defaults to \code{r_squared}, for difference in R-squared-based variable importance)?}

\item{alpha}{the desired type I error rate (defaults to 0.05).}

\item{cv}{was V-fold cross-validation used to estimate the predictiveness (\code{TRUE}) or was the sample split in two (\code{FALSE}); defaults to \code{FALSE}.}

\item{scale}{scale to compute CI on ("identity" for identity scale, "logit" for logit scale and back-transform)}

\item{na.rm}{logical; should NAs be removed in computation? (defaults to \code{FALSE})}
}
\value{
\code{TRUE} if the null hypothesis is rejected (i.e., if the confidence intervals do not overlap); otherwise, \code{FALSE}.
}
\description{
Perform a hypothesis test against the null hypothesis of zero importance by:
(i) for a user-specified level \eqn{\alpha}, compute a \eqn{(1 - \alpha)\times 100}\% confidence interval around the predictiveness for both the full and reduced regression functions (these must be estimated on independent splits of the data);
(ii) if the intervals do not overlap, reject the null hypothesis.
}
\details{
See the paper by Williamson, Gilbert, Simon, and Carone for more
details on the mathematics behind this function and the definition of the parameter of interest.
}
