% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vimp_update.R
\name{vimp_update}
\alias{vimp_update}
\title{Estimate the influence function for variable importance parameters}
\usage{
vimp_update(
  full,
  reduced,
  y,
  folds = folds,
  weights = rep(1, length(y)),
  type = "r_squared",
  na.rm = FALSE
)
}
\arguments{
\item{full}{fitted values from a regression of the outcome on the full set of covariates.}

\item{reduced}{fitted values from a regression either (1) of the outcome on the reduced set of covariates, or (2) of the fitted values from the full regression on the reduced set of covariates.}

\item{y}{the outcome.}

\item{folds}{the folds for hypothesis testing.}

\item{weights}{weights for the computed influence curve (e.g., inverse probability weights for coarsened-at-random settings)}

\item{type}{which parameter are you estimating (defaults to \code{anova}, for ANOVA-based variable importance)?}

\item{na.rm}{logical; should NAs be removed in computation? (defaults to \code{FALSE})}
}
\value{
The influence function values for the given group of left-out covariates.
}
\description{
Compute the value of the influence function for the given group of left-out covariates.
}
\details{
See the paper by Williamson, Gilbert, Simon, and Carone for more
details on the mathematics behind this function and the definition of the parameter of interest.
}
