% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VirtualArray-replace.R,
%   R/RasterArray-replace.R, R/SfArray-replace.R
\name{[<-,VirtualArray,ANY,ANY,logical-method}
\alias{[<-,VirtualArray,ANY,ANY,logical-method}
\alias{[<-,VirtualArray-method}
\alias{[<-,RasterArray,ANY,ANY,SpatRaster-method}
\alias{[<-,SfArray,ANY,ANY,sf-method}
\title{Replace layers in an object that is of a class derived from '\code{\link[via:XArray-class]{VirtualArray}}'.}
\usage{
\S4method{[}{VirtualArray,ANY,ANY,logical}(x, i, j, ...) <- value

\S4method{[}{RasterArray,ANY,ANY,SpatRaster}(x, i, j, ...) <- value

\S4method{[}{SfArray,ANY,ANY,sf}(x, i, j, ...) <- value
}
\arguments{
\item{x}{\code{\link[via:XArray-class]{VirtualArray}}-class object.}

\item{i}{subscript of the first dimension(rows) or vector-like subsetting.}

\item{j}{subscript of the second dimension (columns).}

\item{...}{subscript of additional dimensions.}

\item{value}{A same class object as \code{x}.}
}
\value{
The function has no return value.
}
\description{
Single bracket \code{'['} refers to indices and names within the '\code{\link[via:XArray-class]{VirtualArray}}'-class object. Use double brackets to replace layers based on their names (in the \code{@stack}).
Object types of the same kind class can be used to replace values in '\code{\link[via:XArray-class]{XArray}}'-class objects. '\code{\link[terra:rast]{SpatRaster}}'-class objects can be used to replace values in '\code{\link[via:RasterArray-class]{RasterArray}}'-class objects. Classes inheriting from '\code{\link[sf:sf]{sf}}' can be used with '\code{\link{SfArray}}'-class objects.
}
\examples{
ex <- rastex() 
# replace third element with missing value
ex[3] <- NA
# duplicate first element and make it the second too
ex[2] <- ex[1]
ex

}
