% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuel_corr.R
\name{fuel_corr}
\alias{fuel_corr}
\title{Correction due Fuel effects}
\usage{
fuel_corr(
  euro,
  g = c(e100 = 52, aro = 39, o2 = 0.4, e150 = 86, olefin = 10, s = 165),
  d = c(den = 840, pah = 9, cn = 51, t95 = 350, s = 400)
)
}
\arguments{
\item{euro}{Character; Euro standards ("PRE", "I", "II", "III", "IV", "V",
VI, "VIc")}

\item{g}{Numeric; vector with parameters of gasoline with the names:
e100(vol. %), aro (vol. %), o2 (wt. %), e150 (%), olefin vol. % and s
(sulphur, ppm)}

\item{d}{Numeric; vector with parameters for diesel with the names:
den (density at 15 celcius degrees kg/m3), pah (%), cn (number), t95
(Back end distillation in Celcius degrees) and s  (sulphur, ppm)}
}
\value{
A list with the correction of emission factors.
}
\description{
Take into account the effect of better fuels on vehicles with
older technology. If the ratio is less than 1, return 1. It means that it is
nota degradation function.
}
\note{
This function cannot be used to account for deterioration, therefore,
it is restricted to values between 0 and 1.
Parameters for gasoline (g):

O2 = Oxygenates in %

S = Sulphur content in ppm

ARO = Aromatics content in %

OLEFIN = Olefins content in %

E100 = Mid range volatility in %

E150 = Tail-end volatility in %

Parameters for diesel (d):

DEN = Density at 15 C (kg/m3)

S = Sulphur content in ppm

PAH = Aromatics content in %

CN = Cetane number

T95 = Back-end distillation in o C.
}
\examples{
\dontrun{
f <- fuel_corr(euro = "I")
names(f)
}
}
