% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/speciate.R
\name{speciate}
\alias{speciate}
\title{Speciation of emissions}
\usage{
speciate(x, spec = "bcom", veh, fuel, eu, show = FALSE, list = FALSE, dx)
}
\arguments{
\item{x}{Emissions estimation}

\item{spec}{speciation: The speciations are: "bcom", tyre" (or "tire"), "brake", "road",
"iag", "nox" and "nmhc". 'iag' now includes a speciation for use of industrial and
building paintings. "bcom" stands for black carbon and organic matter. "pmiag"
speciates PM2.5 and requires only argument x of PM2.5 emissions in g/h/km^2 as
gridded emissions (flux). It also accepts one of the following pollutants:
'e_eth', 'e_hc3', 'e_hc5', 'e_hc8', 'e_ol2', 'e_olt', 'e_oli',
'e_iso', 'e_tol', 'e_xyl', 'e_c2h5oh', 'e_hcho', 'e_ch3oh', 'e_ket',
"e_so4i", "e_so4j", "e_no3i", "e_no3j", "e_pm2.5i",
"e_pm2.5j", "e_orgi", "e_orgj", "e_eci", "e_ecj". Also "h2o"}

\item{veh}{Type of vehicle:
When spec is "bcom" or "nox" veh can be "PC", "LCV", HDV" or "Motorcycle".
When spec is "iag" veh can take two values depending:
when the speciation is for vehicles veh accepts "veh", eu "Evaporative",
"Liquid" or "Exhaust" and fuel "G", "E" or "D",
when the speciation is for painting, veh is "paint" fuel or eu can be
"industrial" or "building"
when spec is "nmhc", veh can be "LDV" with fuel "G" or "D" and eu "PRE", "I",
"II", "III", "IV", "V", or "VI".
when spec is "nmhc", veh can be "HDV" with fuel "D" and eu  "PRE", "I",
"II", "III", "IV", "V", or "VI".
when spec is "nmhc" and fuel is "LPG", veh and eu must be "ALL"}

\item{fuel}{Fuel. When spec is "bcom" fuel can be "G" or "D".
When spec is "iag" fuel can be "G", "E" or "D". When spec is "nox" fuel can
be "G", "D", "LPG", "E85" or "CNG". Not required for "tyre", "brake" or "road".
When spec is "nmhc" fuel can be G, D or LPG.}

\item{eu}{Euro emission standard: "PRE", "ECE_1501", "ECE_1502", "ECE_1503",
"I", "II", "III", "IV",  "V", "III-CDFP","IV-CDFP","V-CDFP", "III-ADFP",
"IV-ADFP","V-ADFP" and "OPEN_LOOP". When spec is "iag" accept the values
"Exhaust" "Evaporative" and "Liquid". When spec is "nox" eu can be
"PRE", "I", "II", "III", "IV", "V", "VI", "VIc", "III-DPF" or "III+CRT".
Not required for "tyre", "brake" or "road"}

\item{show}{when TRUE shows row of table with respective speciation}

\item{list}{when TRUE returns a list with number of elements of the list as
the number species of pollutants}

\item{dx}{Integer, used when spec = "pmiag". It is the spatial disntace}
}
\value{
dataframe of speciation in grams or mols
}
\description{
\code{speciate} separates emissions in different compounds.
It covers black carbon and organic matter from particulate matter. Soon it
will be added more speciations
}
\note{
when spec = "iag":
veh is only "veh",
fuel is "G"  (blended with 25\% ethanol), "D" (blended with 5\% of biodiesel)
or "E" (Ethanol 100\%).
eu is "Evaporative", "Liquid" or "Exhaust",

emissions of "pmiag" speciate pm2.5 into e_so4i, e_so4j, e_no3i,
e_no3j, e_mp2.5i, e_mp2.5j, e_orgi, e_orgj, e_eci, e_ecj and h2o. Reference:
Rafee, S.: Estudo numerico do impacto das emissoes veiculares e fixas da
cidade de Manaus nas concentracoes de poluentes atmosfericos da regiao
amazonica, Master thesis, Londrina: Universidade Tecnologica Federal do
Parana, 2015.
}
\examples{
{
# Do not run
pm <- rnorm(n = 100, mean = 400, sd = 2)
df <- speciate(pm, veh = "PC", fuel = "G", eu = "I")
dfa <- speciate(pm, spec = "e_eth", veh = "veh", fuel = "G", eu = "Exhaust")
dfb <- speciate(pm, spec = "e_tol", veh = "veh", fuel = "G", eu = "Exhaust")
dfc <- speciate(pm, spec = "e_so4i")
}
}
\references{
"bcom": Ntziachristos and Zamaras. 2016. Passneger cars, light
commercial trucks, heavy-duty vehicles including buses and motor cycles. In:
EEA, EMEP. EEA air pollutant emission inventory guidebook-2009. European
Environment Agency, Copenhagen, 2016

"tyre", "brake" and "road": Ntziachristos and Boulter 2016.
Automobile tyre and brake wear and road abrasion. In: EEA, EMEP. EEA air
pollutant emission inventory
guidebook-2009. European Environment Agency, Copenhagen, 2016

"iag": Ibarra-Espinosa S. Air pollution modeling in Sao Paulo
using bottom-up vehicular emissions inventories. 2017. PhD thesis. Instituto de
Astronomia, Geofisica e Ciencias Atmosfericas, Universidade de Sao Paulo,
Sao Paulo, page 88.
Speciate EPA: https://cfpub.epa.gov/speciate/. :
K. Sexton, H. Westberg, "Ambient hydrocarbon and ozone measurements downwind
of a large automotive painting plant" Environ. Sci. Tchnol. 14:329 (1980).P.A.
Scheff, R.A. Schauer, James J., Kleeman, Mike J., Cass, Glen R., Characterization
and Control of Organic Compounds Emitted from Air Pollution Sources, Final Report,
Contract 93-329, prepared for California Air Resources Board Research Division,
Sacramento, CA, April 1998.
2004 NPRI National Databases as of April 25, 2006,
http://www.ec.gc.ca/pdb/npri/npri_dat_rep_e.cfm. Memorandum
Proposed procedures for preparing composite speciation profiles using
Environment Canada s National Pollutant Release Inventory (NPRI) for
stationary sources, prepared by Ying Hsu and Randy Strait of E.H. Pechan
Associates, Inc. for David Niemi, Marc Deslauriers, and Lisa Graham of
Environment Canada, September 26, 2006.
}
