% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ef_ldv_speed.R
\name{ef_ldv_speed}
\alias{ef_ldv_speed}
\title{Emissions factors for Light Duty Vehicles and Motorcycles}
\usage{
ef_ldv_speed(v, t, cc, f, eu, p, k = 1, show.equation = TRUE)
}
\arguments{
\item{v}{Category vehicle: "PC", "LCV", "Motorcycle" or "Moped}

\item{t}{Sub-category of of vehicle: "PRE_ECE", "ECE_1501", "ECE_1502",
"ECE_1503", "ECE_1504" , "IMPROVED_CONVENTIONAL", "OPEN_LOOP", "ALL",
"2S"  or "4S"}

\item{cc}{Size of engine in cc: "ALL", "<=1400", ">1400", "1400_2000", ">2000",
"<=800", "800_1400", "<=2000", "2S", "<=50", ">=50", "<=250", "250_750", ">=750",
or ">50"}

\item{f}{Type of fuel: "G", "D", "LPG" or "FH" (Full Hybrid: starts by electric motor)}

\item{eu}{Euro standard: "PRE", "I", "II", "III", "III+DPF", "IV", "V", "VI", "VIc"
or "ALL"}

\item{p}{Pollutant: "CO", "FC", "NOx", "HC" or "PM"}

\item{k}{Multiplication factor}

\item{show.equation}{Option to see or not the equation parameters}
}
\value{
an emission factor function which depends of the average speed V  g/km
}
\description{
This function returns speed dependent emission factors. The emission factors
 comes from the guidelines  EMEP/EEA air pollutant emission inventory guidebook
http://www.eea.europa.eu/themes/air/emep-eea-air-pollutant-emission-inventory-guidebook
}
\details{
The argument of this functions have several options which results in
different combinations that returns emission factors. If a combination of
any option is wrong it will return an empty value. Therefore, it is
important ti know the combinations.
}
\note{
t = "ALL" and cc == "ALL" works for several pollutants because emission
fators are the same. Some exceptions are with NOx and FC because size of engine.
}
\examples{
\dontrun{
# Do not run
# Passenger Cars PC
# Emission factor function
V <- 0:150
ef1 <- ef_ldv_speed(v = "PC",t = "ALL", cc = "ALL", f = "G", eu = "PRE",
p = "CO")
efs <- EmissionFactors(ef1(1:150))
plot(Speed(1:150), efs, xlab = "speed[km/h]")

# List of Copert emission factors for 40 years fleet of Passenger Cars.
# Assuming a euro distribution of euro V, IV, III, II, and I of
# 5 years each and the rest 15 as PRE euro:
euro <- c(rep("V", 5), rep("IV", 5), rep("III", 5), rep("II", 5),
          rep("I", 5), rep("PRE", 15))
speed <- 25
lef <- lapply(1:40, function(i) {
ef_ldv_speed(v = "PC", t = "ALL", cc = "ALL", f = "G",
          eu = euro[i], p = "CO", show.equation = F)(25) })
# to check the emission factor with a plot
efs <- EmissionFactors(unlist(lef)) #returns 'units'
plot(efs, xlab = "age")
lines(efs, type = "l")

# Light Commercial Vehicles
V <- 0:150
ef1 <- ef_ldv_speed(v = "LCV",t = "ALL", cc = "ALL", f = "G", eu = "PRE",
p = "CO")
efs <- EmissionFactors(ef1(1:150))
plot(Speed(1:150), efs, xlab = "speed[km/h]")
lef <- lapply(1:40, function(i) {
ef_ldv_speed(v = "LCV", t = "ALL", cc = "ALL", f = "G",
          eu = euro[i], p = "CO", show.equation = F)(25) })
# to check the emission factor with a plot
efs <- EmissionFactors(unlist(lef)) #returns 'units'
plot(efs, xlab = "age")
lines(efs, type = "l")

# Motorcycles
V <- 0:150
ef1 <- ef_ldv_speed(v = "Motorcycle",t = "4S", cc = "<=250", f = "G",
eu = "PRE", p = "CO")
efs <- EmissionFactors(ef1(1:150))
plot(Speed(1:150), efs, xlab = "speed[km/h]")
# euro for motorcycles
eurom <- c(rep("III", 5), rep("II", 5), rep("I", 5), rep("PRE", 25))
lef <- lapply(1:30, function(i) {
ef_ldv_speed(v = "Motorcycle", t = "4S", cc = "<=250", f = "G",
eu = eurom[i], p = "CO",
show.equation = F)(25) })
efs <- EmissionFactors(unlist(lef)) #returns 'units'
plot(efs, xlab = "age")
lines(efs, type = "l")
}
}
\keyword{emission}
\keyword{factors}
\keyword{speed}
