% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emis_wear.R
\name{emis_wear}
\alias{emis_wear}
\title{Emission estimation from tyre, break and road surface wear}
\usage{
emis_wear(veh, lkm, ef, agemax, profile, hour = 1, day = 1)
}
\arguments{
\item{veh}{Object of class "Vehicles"}

\item{lkm}{Length of the road}

\item{ef}{list of emission factor functions class "EmissionFactorsList",
length equals to hours.}

\item{agemax}{Age of oldest vehicles for that category}

\item{profile}{Numerical or dataframe with nrows equal to 24 and ncol
7 day of the week}

\item{hour}{Number of considered hours in estimation}

\item{day}{Number of considered days in estimation}
}
\value{
emission estimation  g/h
}
\description{
Estimation of wear emissions. The sources are tyres, breaks
and road surface.
}
\examples{
\dontrun{
# Do not run
}
}
\references{
Ntziachristos and Boulter 2016. Automobile tyre and break wear
and road abrasion. In: EEA, EMEP. EEA air pollutant emission inventory
guidebook-2009. European Environment Agency, Copenhagen, 2016
}
