% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap_bp.R
\name{heatmap.bp}
\alias{heatmap.bp}
\title{Heatmap with barplots}
\usage{
heatmap.bp(x, cbarplot = TRUE, rbarplot = TRUE, legend = TRUE,
  clabels = TRUE, rlabels = TRUE, na.rm = TRUE, scale = c("row",
  "column", "none"), col.ramp = viridisLite::viridis(n = 100, alpha = 1), ...)
}
\arguments{
\item{x}{a numeric matrix.}

\item{cbarplot}{a logical indicating whether the columns should be summarized with a barplot.}

\item{rbarplot}{a logical indicating whether the rows should be summarized with a barplot.}

\item{legend}{a logical indicating whether a legend should be plotted.}

\item{clabels}{a logical indicating whether column labels should be included.}

\item{rlabels}{a logical indicating whether row labels should be included.}

\item{na.rm}{a logical indicating whether missing values should be removed.}

\item{scale}{character indicating if the values should be centered and scaled in either the row direction or the column direction, or none. The default is "none".}

\item{col.ramp}{vector of colors to be used for the color ramp.}

\item{...}{additional arguments to be passed on.}
}
\description{
Heatmap of a numeric matrix with barplots summarizing columns and rows.
}
\details{
The function heatmap.bp creates a heatmap from a numeric matrix with optional barplots to summarize the rows and columns.
}
\examples{
library(vcfR)

x  <- as.matrix(mtcars)

heatmap.bp(x)
heatmap.bp(x, scale="col")
# Use an alternate color ramp
heatmap.bp(x, col.ramp = colorRampPalette(c("red", "yellow", "#008000"))(100))
heatmap.bp(x)

 
}
\seealso{
\code{\link[stats]{heatmap}}, \code{\link[graphics]{image}}, heatmap2 in \href{https://cran.r-project.org/package=gplots}{gplots}.
}

