\name{sieveplot}
\alias{sieveplot}
\alias{sieveplot.default}
\alias{sieveplot.formula}
\encoding{latin1}
\title{Sieve Plots}
\description{
  Visualization of two-way contingency tables: plots rectangles with
  areas proportional to the expected cell frequencies and filled with a
  number of squares equal to the observed frequencies.  Thus, the
  densities visualize the deviations of the observed from the expected
  values.
}
\usage{
\method{sieveplot}{default}(x, reverse_y = TRUE, type = c("observed", "expected"),
  main = deparse(substitute(x)),
  values = c("none", "cells", "margins", "both"),
  frequencies = c("absolute", "relative"),
  sieve_colors = c("red","blue"),
  sieve_lty = c("longdash", "solid"), exp_color = "gray",
  exp_lty = "dotted", margin = 0.01, newpage = TRUE, pop = TRUE,
  margins = c(4,3,4,4), xlab = names(dimnames(x))[2],
  ylab = names(dimnames(x))[1], \dots)
\method{sieveplot}{formula}(formula, data = NULL, \dots, subset)
}
\arguments{
  \item{x}{a two-way contingency table, as generated by
    \code{\link{table}}.}
  \item{reverse_y}{logical; if \code{TRUE}, the y axis is reversed
    (i.e., the rectangles' positions correspond to the contingency
    table).}
  \item{type}{switch indicating whether rectangles should be filled
    according to \code{observed} or \code{expected} frequencies.}
  \item{main}{character string specifying the title.}
  \item{values}{switch indicating whether the frequencies of
    \code{cells} or \code{margins} or of \code{both} should be plotted.}
  \item{frequencies}{switch indicating the type of these frequencies:
    \code{relative} or \code{absolute}.}
  \item{sieve_colors, sieve_lty}{vectors with up to two color/line type
    entries: the first is used for negative and the second for positive
    deviations from the expected frequencies.}
  \item{exp_color, exp_lty}{color/line type entry for the expected
    values grid.}
  \item{margin}{lines of margin between the cell rectangles.}
  \item{margins}{vector of margins (see \code{\link[graphics]{par}}).}
  \item{newpage}{logical; if \code{TRUE}, the plot is drawn on a new page.}
  \item{pop}{logical; if \code{TRUE}, all newly generated viewports are popped after plotting.}
  \item{xlab, ylab}{labels of x- and y-axis.}
  \item{formula}{a formula, such as \code{y ~ x}.
    For details, see \code{\link{xtabs}}.}
  \item{data}{a data frame (or list), or a contingency table from which
    the variables in \code{formula} should be taken.}
  \item{subset}{an optional vector specifying a subset of the rows in
    the data frame to be used for plotting.}
  \item{\dots}{further graphics parameters (see \code{\link{gpar}}).}
}
\references{
  H. Riedwyl & M. Schpbach (1994),
  Parquet diagram to plot contingency tables.
  In F. Faulbaum (ed.),
  \emph{Softstat '93: Advances in Statistical Software}, 293--299.
  Gustav Fischer, New York.

  M. Friendly (2000),
  Visualizing Categorical Data,
  SAS Institute, Cary, NC.
}
\author{
  David Meyer \email{David.Meyer@R-project.org}
}
\seealso{
  \code{\link{mosaic}}
}
\examples{
data(HairEyeColor)

## aggregate over 'sex':
(tab <- margin.table(HairEyeColor, c(2,1)))

## plot expected values:
sieveplot(tab, type = "expected", values = "both")

## plot sieve diagram:
sieveplot(tab)

## an example for the formula interface:
data(VisualAcuity)
sieveplot(Freq ~ right + left,  data = VisualAcuity, reverse_y = FALSE)
}
\keyword{category}
\keyword{hplot}
