% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmdcm_vb.R
\name{hm_dcm}
\alias{hm_dcm}
\title{for the hidden Markov DCM.}
\usage{
hm_dcm(
  X,
  Q,
  max_it = 500,
  epsilon = 1e-04,
  nondecreasing_attribute = FALSE,
  model = "General",
  verbose = TRUE,
  random_block_design = FALSE,
  Test_versions = NULL,
  Test_order = NULL,
  random_start = FALSE,
  A_0 = NULL,
  B_0 = NULL,
  delta_0 = NULL,
  ommega_0 = NULL
)
}
\arguments{
\item{X}{T-length list or 3-dim array whose each element is I by J/T binary item response data matrix}

\item{Q}{T-length list or 3-dim array whose each element is J/T by K Q-matrix}

\item{max_it}{Maximum number of iterations (default: 500)}

\item{epsilon}{convergence tolerance for iterations (default: 1e-4)}

\item{nondecreasing_attribute}{logical; whether the assumption that mastered attributes are not forgotten is adopted or not (default: FALSE)}

\item{model}{"General" or "DINA" (default: "General"), specifies the measurement model}

\item{verbose}{logical, controls whether to print progress (default: TRUE)}

\item{random_block_design}{logical value; whether the test design adopts different item ordering or not (default: FALSE)}

\item{Test_versions}{indicates the test module each respondent is assigned (default: NULL)}

\item{Test_order}{the square matrix of order T that represents item order (default: NULL)}

\item{random_start}{logical (default: FALSE)}

\item{A_0}{the value of hyperparameter \eqn{A^0} (default: NULL)}

\item{B_0}{the value of hyperparameter \eqn{B^0} (default: NULL)}

\item{delta_0}{the value of hyperparameter delta_0 (default: NULL)}

\item{ommega_0}{the value of hyperparameter ommega_0 (default: NULL)}
}
\value{
A list including:
\describe{
  \item{theta_est}{the estimate of conditional response probability parameter \eqn{\Theta}}
  \item{theta_sd}{the posterior standard deviation of parameter \eqn{\Theta}}
  \item{pi_est}{the estimate of class mixing parameter \eqn{\pi}}
  \item{pi_sd}{the posterior standard deviation of parameter \eqn{\pi}}
  \item{Tau_est}{the estimate of class-transition probability parameter \eqn{\tau}}
  \item{Tau_sd}{the posterior standard deviation of parameter \eqn{\tau}}
  \item{post_max_class}{the result of class analysis}
  \item{MAP_att_pat}{the MAP estimate of attribute mastery patterns}
  \item{att_master_prob}{the estimated attribute mastery probabilities}
  \item{EAP_att_pat}{the EAP estimate of attribute mastery patterns}
  \item{A_ast}{the estimate of variational parameter \eqn{A^*}}
  \item{B_ast}{the estimate of variational parameter \eqn{B^*}}
  \item{delta_ast}{the estimate of variational posterior \eqn{\delta^*}}
  \item{ommega_ast}{the estimate of variational posterior \eqn{\Omega^*}}
  \item{E_z_itl}{the resulted expectations of  attribute mastery pattern}
  \item{E_z_itl_z_itm1l}{the resulted expectations of  attribute mastery pattern at the time point t and t-1}
  \item{A_0}{the value of hyperparameter \eqn{A^0}}
  \item{B_0}{the value of hyperparameter \eqn{B^0}}
  \item{delta_0}{the computed or entered value of delta_0}
  \item{ommega_0}{the computed or entered value of ommega_0}
  \item{l_lb}{the list of the values of evidence lower bound in each itertion}
  \item{G_jt}{the computed G-matrices}
  \item{m}{the number of performed iterations}
}
}
\description{
\code{hm_dcm()} returns variational Bayesian estimates for the hidden
Markov DCM.
}
\examples{
indT = 3
Q = sim_Q_J30K3
hm_sim_Q = lapply(1:indT,function(time_point) Q)
hm_sim_data = hmdcm_data_gen(Q=hm_sim_Q,I=200)
res_hm = hm_dcm(X=hm_sim_data$X,Q=hm_sim_Q)

}
\references{
Yamaguchi, K., & Martinez, A. J. (2023). Variational Bayes
inference for hidden Markov diagnostic classification models. \emph{British Journal
of Mathematical and Statistical Psychology}, 00, 1– 25. \doi{10.1111/bmsp.12308}
}
