% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{write.basic.pdb}
\alias{write.basic.pdb}
\title{Write Basic PDB File}
\usage{
write.basic.pdb(file, atoms.oi)
}
\arguments{
\item{file}{Filename with ".pdb" extension.}

\item{atoms.oi}{The atoms \code{\link[base:data.frame]{base::data.frame()}}.}
}
\value{
Writes a PDB file for the \code{\link[=FreeSASA.diff]{FreeSASA.diff()}} function.
}
\description{
Writes standard PDB file.
}
\details{
Using the \code{\link[bio3d:write.pdb]{bio3d::write.pdb()}} function this function writes a PDB
file from a \code{\link[base:data.frame]{base::data.frame()}} containing the typical PDB file
information. This function is called from the \code{\link[=FreeSASA.diff]{FreeSASA.diff()}} function
within the \code{\link[=HydrophilicityEvaluation]{HydrophilicityEvaluation()}} function.

\emph{\strong{NOTE}}: This is a non-public function.
}
\examples{
  \dontrun{
    write.basic.pdb(file = "just_some_PDB.pdb", atoms.oi)
  }

}
\seealso{
Other utilities: \code{\link{ConservationSet}},
  \code{\link{DetermineChainsOfInterest}},
  \code{\link{ExtractFileTimeStamp}},
  \code{\link{ExtractPDBids}}, \code{\link{FileTimeStamp}},
  \code{\link{HasXWaters}}, \code{\link{Nearby}},
  \code{\link{ProtHetWatIndices}},
  \code{\link{RescaleValues}},
  \code{\link{RetainChainsOfInterest}},
  \code{\link{ReturnPDBfullPath}},
  \code{\link{StandardizeAsparticAcidNames}},
  \code{\link{StandardizeCysteineNames}},
  \code{\link{StandardizeGlutamicAcidNames}},
  \code{\link{StandardizeHistidineNames}},
  \code{\link{StandardizeLysineNames}},
  \code{\link{TimeSpan}}, \code{\link{UniqueAtomHashes}},
  \code{\link{aaStandardizeNames}},
  \code{\link{getAtomTypeCounts}},
  \code{\link{getResTypeCounts}}, \code{\link{res2xyz}},
  \code{\link{resAtomType2AtomClass}},
  \code{\link{write.conservedWaters.pdb}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
