% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{res2xyz}
\alias{res2xyz}
\title{Residue Indices to Coordinate Indices}
\usage{
res2xyz(res.idc)
}
\arguments{
\item{res.idc}{Indicies of residues to convert to coordinate indices}
}
\value{
Vector of coordinate indicies to be applied to \code{pdb$xyz}
}
\description{
Return the coordinate indices for the provided residue indices.
}
\details{
Using the residue indices of the atoms
\code{\link[base:data.frame]{base::data.frame()}} (\emph{e.g.}, \code{pdb$atom}) determine the
coodinate indices of the residue atoms (\emph{e.g.}, \code{pdb$xyz}).
}
\examples{
  res.idc <- c(5:10)
  res2xyz(res.idc)
  # [1] 13 15 15 16 18 18 19 21 21 22 24 24 25 27 27 28 30

}
\seealso{
Other utilities: \code{\link{ConservationSet}},
  \code{\link{DetermineChainsOfInterest}},
  \code{\link{ExtractFileTimeStamp}},
  \code{\link{ExtractPDBids}}, \code{\link{FileTimeStamp}},
  \code{\link{HasXWaters}}, \code{\link{Nearby}},
  \code{\link{ProtHetWatIndices}},
  \code{\link{RescaleValues}},
  \code{\link{RetainChainsOfInterest}},
  \code{\link{ReturnPDBfullPath}},
  \code{\link{StandardizeAsparticAcidNames}},
  \code{\link{StandardizeCysteineNames}},
  \code{\link{StandardizeGlutamicAcidNames}},
  \code{\link{StandardizeHistidineNames}},
  \code{\link{StandardizeLysineNames}},
  \code{\link{TimeSpan}}, \code{\link{UniqueAtomHashes}},
  \code{\link{aaStandardizeNames}},
  \code{\link{getAtomTypeCounts}},
  \code{\link{getResTypeCounts}},
  \code{\link{resAtomType2AtomClass}},
  \code{\link{write.basic.pdb}},
  \code{\link{write.conservedWaters.pdb}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
