% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openxlsxCommands.R
\name{oxPlainDataSheet}
\alias{oxPlainDataSheet}
\title{Plain Data Sheet}
\usage{
oxPlainDataSheet(wb.name, sheet.name = "basic", df)
}
\arguments{
\item{wb.name}{Name of the workbook for the results; \emph{e.g.}, results.wb}

\item{sheet.name}{Name of the worksheet being formatted; default:
\code{"basic"}}

\item{df}{data.frame containing the data to be written; \emph{e.g.}, \code{df.results}}
}
\value{
The workbook containing the indicated and newly formatted worksheet.
}
\description{
Constructs a plain Excel worksheet via the \link{openxlsx} package.
}
\details{
\strong{This function creates a basic Excel worksheet with minimal
formatting.}

Notable formatting:
\itemize{
\item Top row frozen
\item Column widths are set based on column content
}

This \link{openxlsx} function is \emph{\strong{NOT}} exported.
}
\seealso{
Other "openxlsx functions": \code{\link{openxlsxCellStyles}},
  \code{\link{oxAlignOverlapSheet}},
  \code{\link{oxClusterStatsSheet}},
  \code{\link{oxClusterSummarySheet}},
  \code{\link{oxInitWaterDataSheet}},
  \code{\link{oxPDBcleanedSummarySheet}},
  \code{\link{oxRCSBinfoSheet}},
  \code{\link{oxWaterOccurrenceSheet}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
