% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Constants.R
\docType{data}
\name{names.polar.atoms}
\alias{names.polar.atoms}
\title{Polar Atom Names}
\format{An object of class \code{character} of length 20.}
\usage{
names.polar.atoms
}
\description{
Polar atom names based on PDB atom naming conventions.
}
\details{
Polar atoms are those possessing a lone pair(s) of elections able to
participate in hydrogen bonds with hydrogen atoms within 3.5 Angstroms and
XX degrees of the lone pair containing atom. Traditionally, nitrogen,
oxygen, and sulfur atoms possess lone pair(s) of electrons and participate
in hydrogen bonds in biological sytems. Water molecules are able to
hydrogen bond with and participate in hydrogen bonds.
}
\examples{
  names.polar.atoms
  # [1] "N"   "NE"  "NH1" "NH2" "ND2" "NE2" "ND1" "NZ"  "NE1" "O"   "OD1"
  #     "OD2" "OE1" "OE2" "OG"  "OG1" "OH"  "S"   "SD"  "SG"

}
\seealso{
Other constants: \code{\link{names.backbone.atoms}},
  \code{\link{names.res.AtomTypes}},
  \code{\link{names.resATs.carb.sulf}},
  \code{\link{names.resATs.nitro.neut}},
  \code{\link{names.resATs.nitro.pos}},
  \code{\link{names.resATs.oxy.neg}},
  \code{\link{names.resATs.oxy.neut}},
  \code{\link{names.residues}},
  \code{\link{names.sidechain.atoms}},
  \code{\link{names.waters}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\keyword{datasets}
