% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CleanProteinStructures.R
\name{RemoveOoR.b}
\alias{RemoveOoR.b}
\title{Remove B-value Out of Range Atoms}
\usage{
RemoveOoR.b(atoms.chains.oi)
}
\arguments{
\item{atoms.chains.oi}{The data.frame containing the PDB file information;
aka the PDB structure}
}
\value{
data.frame of the PDB structure \emph{without} the offending atoms
}
\description{
Removes atoms with B-values out of accepted range.
}
\details{
Accepted B-value values range from 0 to 100 with values. Atoms are
considered stationary -- possessing low thermal energy -- when possessing
values between 20 and 40 while larger values between 60 and 100 indicate a
large amount of position variability within the lattice. This function
identifies occupancy values less than 0 and greater than 100 and removes
them from the structure.
}
\examples{
  \donttest{
  nrow(PDB.4ape$atom)
  PDB.4ape.OoR.b <- RemoveOoR.b(PDB.4ape$atom)
  nrow(PDB.4ape.OoR.b)
  }

}
\seealso{
Other "Clean Protein Structure": \code{\link{CleanProteinStructures}},
  \code{\link{RemoveHydrogenAtoms}},
  \code{\link{RemoveModeledAtoms}},
  \code{\link{RemoveOoR.o}},
  \code{\link{RetainWatersWithinX}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
