% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CleanProteinStructures.R
\name{RemoveModeledAtoms}
\alias{RemoveModeledAtoms}
\title{Remove Modeled Atoms}
\usage{
RemoveModeledAtoms(atoms.chains.oi)
}
\arguments{
\item{atoms.chains.oi}{The data.frame containing the PDB file information;
aka the PDB structure}
}
\value{
data.frame of the PDB structure \emph{without} the modeled atoms
}
\description{
Removes modeled atoms from a RCSB/PDB structure.
}
\details{
Sometimes atoms are not well resolved within the electron density
maps and the scientists resolving/determining the structures "model back
into" the resulting structure the atoms based on historical data. This is
most common for residues where a portion of the residue is missing and
based on the structure the missing atoms are replaces. These modeled atoms
have an occupancy value of 0.01 or less and are identified and removed.

The reported occupancy value of 0.01 is used as the cutoff because several
PDB structures have comments in the \code{REMARK 3} section stating,
\code{"...MISSING ABOVE 1SIGMA WERE GIVEN A 0.01 OCCUPANCY..."`` or}"...WITH NO DENSITIES ARE GIVEN OCCUPANCY VALUES OF 0.01..."`.
}
\examples{
  \donttest{
  PDB.1ecd.noModeledAtoms <- RemoveModeledAtoms(PDB.1ecd$atom)
  }

}
\seealso{
Other "Clean Protein Structure": \code{\link{CleanProteinStructures}},
  \code{\link{RemoveHydrogenAtoms}},
  \code{\link{RemoveOoR.b}}, \code{\link{RemoveOoR.o}},
  \code{\link{RetainWatersWithinX}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
