% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{FileTimeStamp}
\alias{FileTimeStamp}
\title{Filename Time Stamp}
\usage{
FileTimeStamp(current.time)
}
\arguments{
\item{current.time}{The current time determined with \code{\link[base:as.POSIXct]{base::as.POSIXct()}}}
}
\value{
A string with the date and time.
}
\description{
Date-time string to make file names unique
}
\details{
Create a date-time string to append to filenames to try and make
them unique. The date-time string has the format
month-day-year_hour-minute; for example, May 4, 2016 at 12:34pm is
represented as \code{may042016_1234}.

\emph{\strong{NOTE}}: This is a non-public function.
}
\examples{
  \dontrun{
  current.time <- as.POSIXct("2016-05-04 12:34:56.78", tz = "UTC")
  FileTimeStamp(current.time)
  # [1] may042016_1234
  }

}
\seealso{
Other utilities: \code{\link{ConservationSet}},
  \code{\link{DetermineChainsOfInterest}},
  \code{\link{ExtractFileTimeStamp}},
  \code{\link{ExtractPDBids}}, \code{\link{HasXWaters}},
  \code{\link{Nearby}}, \code{\link{ProtHetWatIndices}},
  \code{\link{RescaleValues}},
  \code{\link{RetainChainsOfInterest}},
  \code{\link{ReturnPDBfullPath}},
  \code{\link{StandardizeAsparticAcidNames}},
  \code{\link{StandardizeCysteineNames}},
  \code{\link{StandardizeGlutamicAcidNames}},
  \code{\link{StandardizeHistidineNames}},
  \code{\link{StandardizeLysineNames}},
  \code{\link{TimeSpan}}, \code{\link{UniqueAtomHashes}},
  \code{\link{aaStandardizeNames}},
  \code{\link{getAtomTypeCounts}},
  \code{\link{getResTypeCounts}}, \code{\link{res2xyz}},
  \code{\link{resAtomType2AtomClass}},
  \code{\link{write.basic.pdb}},
  \code{\link{write.conservedWaters.pdb}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
