% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{ClusterSummaryPlots}
\alias{ClusterSummaryPlots}
\title{Cluster Summary Plots}
\usage{
ClusterSummaryPlots(data, passed.waters = TRUE, plot.labels = NULL)
}
\arguments{
\item{data}{The results from the \code{\link[=ConservedWaters]{ConservedWaters()}} function.}

\item{passed.waters}{Logical indicator to plot results for waters \strong{passing}
\code{\link[=Mobility]{Mobility()}} and \code{\link[=NormalizedBvalue]{NormalizedBvalue()}} \emph{\strong{OR}} using \strong{all} waters within
the \code{PDB} files.}

\item{plot.labels}{Using the same options as \code{\link[cowplot:plot_grid]{cowplot::plot_grid()}} plus
\code{NULL}. The option \code{"AUTO"} labels each plot with upper-case letters
(\emph{e.g.}, A, B, C, D, E), \code{"auto"} labels each plot with lower-case letters
(\emph{e.g.}, a, b, c, d, e), and \code{NULL} returns plots without labels. Default
is \code{NULL}.}
}
\description{
Collection of cluster summary plots.
}
\details{
The Number of Water Cluster (see \code{\link[=ConservationPlot]{ConservationPlot()}}), Occupancy
(see \code{\link[=OccupancyBarplot]{OccupancyBarplot()}}), Mobility (see \code{\link[=MobilityBarplot]{MobilityBarplot()}}), B-value
(see \code{\link[=BvalueBarplot]{BvalueBarplot()}}), and Normalized B-value (see \code{\link[=nBvalueBarplot]{nBvalueBarplot()}})
plots are combined into a single plot image. The ability to label each plot
with capital letters (upper-case) or lower-case letters is available.
}
\examples{
  \dontrun{
  cluster.summary.plot <- ClusterSummaryPlots(data=thrombin10.conservedWaters,
                                             passed.waters=TRUE,
                                             labels=NULL)
  }

}
\references{
Paul C Sanschagrin and Leslie A Kuhn. Cluster analysis of
consensus water sites in thrombin and trypsin shows conservation between
serine proteases and contributions to ligand specificity. \emph{Protein
Science}, 1998, \strong{7} (\emph{10}), pp 2054-2064.
\href{http://doi.org/10.1002/pro.5560071002}{DOI: 10.1002/pro.5560071002}
\href{http://www.ncbi.nlm.nih.gov/pubmed/9792092}{PMID: 9792092}
\href{http://www.kuhnlab.bmb.msu.edu/software/watch/index.html}{WatCH webpage}
}
\seealso{
Other plots: \code{\link{BoundWaterEnvPlots}},
  \code{\link{BoundWaterEnvSummaryPlot}},
  \code{\link{BvalueBarplot.summ}},
  \code{\link{BvalueBarplot}},
  \code{\link{MobNormBvalEvalPlots}},
  \code{\link{MobilityBarplot.summ}},
  \code{\link{MobilityBarplot}},
  \code{\link{OccupancyBarplot.summ}},
  \code{\link{OccupancyBarplot}},
  \code{\link{nBvalueBarplot}},
  \code{\link{normBvalueBarplot.summ}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
