% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precision_profile_plot.R
\name{plot.precision_profile}
\alias{plot.precision_profile}
\alias{autoplot.precision_profile}
\title{Plot method for precision_profile objects}
\usage{
\method{plot}{precision_profile}(
  x,
  show_ci = TRUE,
  show_targets = TRUE,
  show_points = TRUE,
  point_alpha = 0.8,
  point_size = 3,
  line_colors = NULL,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  log_x = FALSE,
  ...
)

\method{autoplot}{precision_profile}(
  object,
  show_ci = TRUE,
  show_targets = TRUE,
  show_points = TRUE,
  point_alpha = 0.8,
  point_size = 3,
  line_colors = NULL,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  log_x = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{precision_profile}.}

\item{show_ci}{Logical; if \code{TRUE} (default), displays prediction interval
bands for the fitted curve.}

\item{show_targets}{Logical; if \code{TRUE} (default), displays horizontal lines
at functional sensitivity target CV values.}

\item{show_points}{Logical; if \code{TRUE} (default), displays the observed
data points.}

\item{point_alpha}{Numeric; transparency of points (0-1, default: 0.8).}

\item{point_size}{Numeric; size of points (default: 3).}

\item{line_colors}{Named character vector with colors for \code{"fitted"},
\code{"ci"}, and \code{"target"}. Defaults to a clean color scheme.}

\item{title}{Character; plot title. If \code{NULL} (default), generates an
automatic title.}

\item{xlab}{Character; x-axis label. If \code{NULL}, uses "Concentration".}

\item{ylab}{Character; y-axis label. If \code{NULL}, uses "CV (\%)".}

\item{log_x}{Logical; if \code{TRUE}, uses logarithmic scale for x-axis
(default: \code{FALSE}).}

\item{...}{Additional arguments (currently ignored).}

\item{object}{An object of class \code{precision_profile}.}
}
\value{
A \code{ggplot} object that can be further customized.
}
\description{
Creates publication-ready visualization of precision profile results,
showing CV vs concentration with the fitted model curve.
}
\details{
The precision profile plot displays:
\itemize{
\item \strong{Observed points}: CV values at each tested concentration
\item \strong{Fitted curve}: Model-predicted CV across the concentration range
\item \strong{Prediction intervals}: Confidence bands showing uncertainty
\item \strong{Target lines}: Horizontal lines at functional sensitivity thresholds
}

The plot helps visualize:
\itemize{
\item How measurement precision changes with concentration
\item Model fit quality (points should follow the curve)
\item Functional sensitivity estimates (intersection of curve with target lines)
}
}
\examples{
# See ?precision_profile for complete examples

}
