% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_jaccard.r
\name{bed_jaccard}
\alias{bed_jaccard}
\title{Calculate jaccard statistics on two sets of intervals.}
\usage{
bed_jaccard(x, y)
}
\arguments{
\item{x}{tbl of intervals}

\item{y}{tbl of intervals}
}
\value{
\code{data_frame} with the following columns:
  \itemize{ 
    \item{\code{len_i}}{ length of the intersection}
    \item{\code{len_u}}{ length of the union}
    \item{\code{jaccard}}{ jaccard statistic} 
    \item{\code{n_int}}{ number of intersecting intervals between x and y}
    }
}
\description{
Calculate jaccard statistics on two sets of intervals.
}
\details{
\code{bed_jaccard()} quantifies the extent of overlap between to sets of
intervals. The Jaccard statistic takes values of \code{[0,1]} and is measured as:

\deqn{ J(x,y) = \frac{\mid x \bigcap y \mid}
                     {\mid x \bigcup y \mid} = 
                \frac{\mid x \bigcap y \mid}
                     {\mid x \mid + \mid y \mid - \mid x \bigcap y \mid} }

Interval statistics can be used in combination with 
  \code{\link[dplyr]{group_by}} and \code{\link[dplyr]{do}} to calculate 
  statistics for subsets of data. See \code{vignette('interval-stats')} for
  examples.
}
\examples{
x <- tibble::tribble(
  ~chrom, ~start, ~end,
  "chr1", 10,     20,
  "chr1", 30,     40
)
 
y <- tibble::tribble(
  ~chrom, ~start, ~end,
  "chr1", 15,     20
)
 
bed_jaccard(x, y)
 
}
\seealso{
\url{http://bedtools.readthedocs.org/en/latest/content/tools/jaccard.html}

Other interval-stats: \code{\link{bed_absdist}},
  \code{\link{bed_fisher}}, \code{\link{bed_projection}},
  \code{\link{bed_reldist}}
}
