% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_intersect.r
\name{bed_intersect}
\alias{bed_intersect}
\title{Identify intersecting intervals.}
\usage{
bed_intersect(x, y, invert = FALSE, suffix = c(".x", ".y"), ...)
}
\arguments{
\item{x}{tbl of intervals}

\item{y}{tbl of intervals}

\item{invert}{report \code{x} intervals not in \code{y}}

\item{suffix}{colname suffixes in output}

\item{...}{extra arguments (not used)}
}
\value{
a \code{data_frame} with original columns from \code{x} and \code{y},
  suffixed with \code{.x} and \code{.y}, and a new \code{.overlap} column 
  with the extent of overlap for the intersecting intervals.
}
\description{
Report intersecting intervals from \code{x} and \code{y} tbls. Book-ended 
intervals (or "touching" intervals) have \code{.overlap} values of \code{0}) 
in the output.
}
\details{
input tbls are grouped by \code{chrom} by default, and additional
  groups can be added using \code{\link[dplyr]{group_by}}. For example,
  grouping by \code{strand} will constrain analyses to the same strand. To
  compare opposing strands across two tbls, strands on the \code{y} tbl can
  first be inverted using \code{\link{flip_strands}}.
}
\examples{
x <- tibble::tribble(
~chrom, ~start, ~end,
'chr1', 25,      50,
'chr1', 100,     125
)

y <- tibble::tribble(
  ~chrom, ~start, ~end,
  'chr1', 30,     75
)

bed_glyph(bed_intersect(x, y))
bed_glyph(bed_intersect(x, y, invert = TRUE))

x <- tibble::tribble(
  ~chrom, ~start, ~end,
  "chr1", 100,    500,
  "chr2", 200,    400,
  "chr2", 300,    500,
  "chr2", 800,    900
)

y <- tibble::tribble(
  ~chrom, ~start, ~end, ~value,
  "chr1", 150,    400,  100,
  "chr1", 500,    550,  100,
  "chr2", 230,    430,  200,
  "chr2", 350,    430,  300
)

bed_intersect(x, y)

bed_intersect(x, y, invert = TRUE)
 
}
\seealso{
\url{http://bedtools.readthedocs.org/en/latest/content/tools/intersect.html}

Other multi-set-ops: \code{\link{bed_closest}},
  \code{\link{bed_coverage}}, \code{\link{bed_map}},
  \code{\link{bed_subtract}}, \code{\link{bed_window}}
}

