% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplify_rules.R
\name{simplify_rules}
\alias{simplify_rules}
\title{Simplify a rule set}
\usage{
simplify_rules(.x, .values = list(...), ...)
}
\arguments{
\item{.x}{\code{\link{validator}} object with the rules to be simplified.}

\item{.values}{optional named list with values that will be substituted.}

\item{...}{parameters that will be used to substitute values.}
}
\description{
Simplifies a rule set set by applying different simplification methods. This is a convenience function that 
works in common cases. The following simplification methods are executed:
\itemize{
 \item \code{\link{substitute_values}}: filling in any parameters that are supplied via \code{.values} or \code{...}.
 \item \code{\link{simplify_fixed_variables}}: find out if there are fixed values. If this is the case, they are substituted.
 \item \code{\link{simplify_conditional}}: Simplify conditional statements, by removing clauses that are superfluous.
 \item \code{\link{remove_redundancy}}: remove redundant rules.
}
For more control, these methods can be called separately.
}
\examples{
rules <- validator( x > 0
                  , if (x > 0) y == 1
                  , A \%in\% c("a1", "a2")
                  , if (A == "a1") y > 1
                  )

simplify_rules(rules)

}
\seealso{
Other redundancy: 
\code{\link{detect_fixed_variables}()},
\code{\link{detect_redundancy}()},
\code{\link{is_implied_by}()},
\code{\link{remove_redundancy}()},
\code{\link{simplify_fixed_variables}()}
}
\concept{redundancy}
