% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-data-frame.R
\name{as.data.frame,tbl_validation-method}
\alias{as.data.frame,tbl_validation-method}
\title{Retrieve validation results as a data.frame}
\usage{
\S4method{as.data.frame}{tbl_validation}(x, row.names = NULL, optional = FALSE, ...)
}
\arguments{
\item{x}{\code{\link[=tbl_validation]{tbl_validation()}}, result of a \code{confront()} of \code{tbl} with a rule set.}

\item{row.names}{ignored}

\item{optional}{ignored}

\item{...}{ignored}
}
\value{
\code{data.frame}, result of the query on the database.
}
\description{
Retrieve validation results as a data.frame
}
\examples{
# create a table in a database
income <- data.frame(id = letters[1:2], age=c(12,35), salary = c(1000,NA))
con <- dbplyr::src_memdb()
tbl_income <- dplyr::copy_to(con, income, overwrite=TRUE)

# Let's define a rule set and confront the table with it:
rules <- validator( is_adult   = age >= 18
                  , has_income = salary > 0
                  , mean_age   = mean(age,na.rm=TRUE) > 20
                  )
# and confront!
cf <- confront(tbl_income, rules, key = "id")
as.data.frame(cf)

# and now with a sparse result:
cf <- confront(tbl_income, rules, key = "id", sparse=TRUE)
as.data.frame(cf)

}
