% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genericrules.R
\name{part_whole_relation}
\alias{part_whole_relation}
\title{Test whether details combine to a chosen aggregate}
\usage{
part_whole_relation(
  values,
  labels,
  whole,
  part = NULL,
  aggregator = sum,
  tol = 1e-08,
  by = NULL,
  ...
)
}
\arguments{
\item{values}{A bare (unquoted) variable name holding the values to aggregate}

\item{labels}{A bare (unquoted) variable name holding the labels indicating
whether a value is an aggregate or a detail.}

\item{whole}{\code{[character]} literal label or pattern recognizing a whole
in \code{labels}. Use \code{\link{glob}} or \code{\link{rx}} to label
as a globbing or regular expression pattern (see examples).}

\item{part}{\code{[character]} vector of label values or pattern recognizing
a part in \code{labels}. Use \code{\link{glob}} or \code{\link{rx}}
to label as a globbing or regular expression pattern. When labeled
with \code{glob} or \code{rx}, it must be a single string. If `part` is
left unspecified, all values not recognized as an aggregate are
interpreted as details that must be aggregated to the whole.}

\item{aggregator}{\code{[function]} used to aggregate subsets of \code{x}. It should
accept a \code{numeric} vector and return a single number.}

\item{tol}{\code{[numeric]} tolerance for equality checking}

\item{by}{Name of variable, or \code{list} of bare variable names, used to
split the values and labels before computing the aggregates.}

\item{...}{Extra arguments passed to aggregator (for example \code{na.rm=TRUE}).}
}
\value{
A \code{logical} vector of size \code{length(value)}.
}
\description{
Data in 'long' format often contain records representing totals
(or other aggregates) as well as records that contain details
that add up to the total. This function facilitates checking the
part-whole relation in such cases.
}
\examples{
df <- data.frame(
   id = 10011:10020
 , period   = rep(c("2018Q1", "2018Q2", "2018Q3", "2018Q4","2018"),2)
 , direction = c(rep("import",5), rep("export", 5))
 , value     = c(1,2,3,4,10, 3,3,3,3,13)
)
## use 'rx' to interpret 'whole' as a regular expression.
rules <- validator(
  part_whole_relation(value, period, whole=rx("^\\\\d{4}$")
  , by=direction)
)

out <- confront(df, rules, key="id")
as.data.frame(out)
}
