% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concat_conserved_kmer.R
\name{concat_conserved_kmer}
\alias{concat_conserved_kmer}
\title{k-mer sequences concatenation}
\usage{
concat_conserved_kmer(
  data,
  conservation_level = "HCS",
  kmer = 9,
  output_type = "csv"
)
}
\arguments{
\item{data}{DiMA JSON converted csv file data}

\item{conservation_level}{CCS (completely conserved) / HCS (highly conserved)}

\item{kmer}{size of the k-mer window}

\item{output_type}{type of the output; "csv" or "fasta"}
}
\value{
A dataframe
}
\description{
This function concatenates completely (index incidence = 100%)/highly (90% <=
index incidence < 100%) conserved k-mer positions that overlapped at least one
k-mer position or are adjacent to each other and generate the CCS/HCS sequence
in either CSv or FASTA format
}
\examples{
csv<-concat_conserved_kmer(proteins_1host)
csv_2hosts<-concat_conserved_kmer(protein_2hosts, conservation_level = "CCS")
fasta <- concat_conserved_kmer(protein_2hosts, output_type = "fasta", conservation_level = "HCS")
}
