% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_annotation.R
\name{partitionVariantFile}
\alias{partitionVariantFile}
\title{Partition the variant file to run in parallel}
\usage{
partitionVariantFile(
  variantFile,
  chunkSize = NULL,
  chunkNum = NULL,
  chunkPath = "chunks",
  species,
  ensemblVersion = NULL,
  overwrite = FALSE,
  dataDir = NULL,
  getTranscript = TRUE,
  format = "csv",
  verbose = FALSE
)
}
\arguments{
\item{variantFile}{variant file in CSV format}

\item{chunkSize}{Partition the variant file into chunk files, which has a certain number of rows}

\item{chunkNum}{Partition the variant file into a certain number of chunk files}

\item{chunkPath}{(optional) A file directory to store all partition files. By default will output to "chunks" folder}

\item{species}{human or mouse}

\item{ensemblVersion}{(optional) a number specifying which version of Ensembl annotation you'd like to use, by default use the latest version}

\item{overwrite}{(optional) If chunkPath already exists and not empty, whether or not to overwrite it. By default, do not overwrite and will raise error.}

\item{dataDir}{(optional) path to store database information, if not specified will create a folder named as input variant file name with a "db_" prefix}

\item{getTranscript}{(optional) Whether to get ids of the transcripts that overlap with all the variants. The default value is TRUE. If the number of variants is too large (for example > 100,000), set it to FALSE and do this in runUTRAnnotation on each partition in parallel.}

\item{format}{(optional) csv or vcf, the default is csv}

\item{verbose}{Whether print diagnostic messages. The default is FALSE.}
}
\value{
a list of partition variant files
}
\description{
\code{partitionVariantFile} is used to partition the variant file into small partition files by user defined size or number
}
\examples{
\donttest{
variants_sample <- system.file("extdata", "variants_sample.csv", package = "utr.annotation")

# Partition variants_sample file equally into 3 variant files
# and store them in user specified chunkPath folder
partitionVariantFile(variantFile = variants_sample,
                     chunkNum = 3,
                     chunkPath = "chunks_3",
                     species = "human",
                     ensemblVersion = 93,
                     dataDir = "db_all_variants")

# Partition variants_sample file into smaller variant files each of which contains 7 variants,
# and store them in user specified chunkPath folder
partitionVariantFile(variantFile = variants_sample,
                     chunkSize = 7,
                     chunkPath = "chunks_7_vars",
                     species = "human",
                     ensemblVersion = 93,
                     dataDir = "db_all_variants")
unlink("db_all_variants", recursive = TRUE)
unlink("chunks_3", recursive = TRUE)
unlink("chunks_7_vars", recursive = TRUE)
}
}
