% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_ecc.R
\name{predict.ECCmodel}
\alias{predict.ECCmodel}
\title{Predict Method for Ensemble of Classifier Chains}
\usage{
\method{predict}{ECCmodel}(object, newdata, vote.schema = "maj",
  probability = getOption("utiml.use.probs", TRUE), ...,
  cores = getOption("utiml.cores", 1), seed = getOption("utiml.seed", NA))
}
\arguments{
\item{object}{Object of class '\code{ECCmodel}'.}

\item{newdata}{An object containing the new input data. This must be a
matrix, data.frame or a mldr object.}

\item{vote.schema}{Define the way that ensemble must compute the predictions.
The default valid options are: c("avg", "maj", "max", "min"). If \code{NULL}
then all predictions are returned. (Default: \code{'maj'})}

\item{probability}{Logical indicating whether class probabilities should be
returned. (Default: \code{getOption("utiml.use.probs", TRUE)})}

\item{...}{Others arguments passed to the base algorithm prediction for all
subproblems.}

\item{cores}{The number of cores to parallelize the training. Values higher
than 1 require the \pkg{parallel} package. (Default:
\code{options("utiml.cores", 1)})}

\item{seed}{An optional integer used to set the seed. This is useful when
the method is run in parallel. (Default: \code{options("utiml.seed", NA)})}
}
\value{
An object of type mlresult, based on the parameter probability.
}
\description{
This method predicts values based upon a model trained by \code{\link{ecc}}.
}
\examples{
\dontrun{
# Predict SVM scores
model <- ecc(toyml)
pred <- predict(model, toyml)

# Predict SVM bipartitions running in 6 cores
pred <- predict(model, toyml, probability = FALSE, cores = 6)

# Return the classes with the highest score
pred <- predict(model, toyml, vote.schema = 'max')
}
}
\seealso{
\code{\link[=ecc]{Ensemble of Classifier Chains (ECC)}}
}
