% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edit.R
\name{edit}
\alias{edit}
\alias{edit_r_profile}
\alias{edit_r_environ}
\alias{edit_r_makevars}
\alias{edit_rstudio_snippets}
\alias{edit_git_config}
\alias{edit_git_ignore}
\title{Open configuration files}
\usage{
edit_r_profile(scope = c("user", "project"))

edit_r_environ(scope = c("user", "project"))

edit_r_makevars(scope = c("user", "project"))

edit_rstudio_snippets(type = "R")

edit_git_config(scope = c("user", "project"))

edit_git_ignore(scope = c("user", "project"))
}
\arguments{
\item{scope}{Edit globally for the current \strong{user}, or locally for the
current \strong{project}}

\item{type}{Snippet type. One of: "R", "markdown", "C_Cpp", "Tex",
"Javascript", "HTML", "SQL"}
}
\value{
Path to the file, invisibly.
}
\description{
\itemize{
\item \code{edit_r_profile()} opens \code{.Rprofile}
\item \code{edit_r_environ()} opens \code{.Renviron}
\item \code{edit_r_makevars()} opens \code{.R/Makevars}
\item \code{edit_git_config()} opens \code{.gitconfig} or \code{.git/config}
\item \code{edit_git_ignore()} opens \code{.gitignore}
\item \code{edit_rstudio_snippets(type)} opens \code{.R/snippets/{type}.snippets}
}
}
\details{
The \code{edit_r_*()} and \code{edit_rstudio_*()} functions consult R's notion of
user's home directory. The \code{edit_git_*()} functions -- and \pkg{usethis} in
general -- inherit home directory behaviour from the \pkg{fs} package, which
differs from R itself on Windows. The \pkg{fs} default is more conventional
in terms of the location of user-level Git config files. See
\code{\link[fs:path_home]{fs::path_home()}} for more details.
}
